/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.ui.util;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconLoader {
    public static Icon load(Class<?> klass, String path) {
        try {
            return new ImageIcon(ImageIO.read(klass.getResourceAsStream(path)));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return environment.getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        if (IconLoader.isHeadless()) {
            return image;
        }
        if (image.getColorModel().equals(IconLoader.getGraphicsConfiguration().getColorModel())) {
            return image;
        }
        BufferedImage compatibleImage = IconLoader.getGraphicsConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }
}

