/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.scene;

import com.android.hierarchyviewer.scene.ViewNode;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewHierarchyScene
extends GraphScene<ViewNode, String> {
    private ViewNode root;
    private LayerWidget widgetLayer;
    private LayerWidget connectionLayer;
    private WidgetAction moveAction = ActionFactory.createMoveAction();

    public ViewHierarchyScene() {
        this.widgetLayer = new LayerWidget((Scene)this);
        this.connectionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.widgetLayer);
        this.addChild((Widget)this.connectionLayer);
    }

    public ViewNode getRoot() {
        return this.root;
    }

    void setRoot(ViewNode root) {
        this.root = root;
    }

    protected Widget attachNodeWidget(ViewNode node) {
        Widget widget = this.createBox(node, node.name, node.id);
        widget.getActions().addAction(this.createSelectAction());
        widget.getActions().addAction(this.moveAction);
        this.widgetLayer.addChild(widget);
        return widget;
    }

    private Widget createBox(ViewNode node, String nodeName, String id) {
        String shortName = ViewHierarchyScene.getShortName(nodeName);
        node.setShortName(shortName);
        GradientWidget box = new GradientWidget(this, node);
        box.setLayout(LayoutFactory.createVerticalFlowLayout());
        box.setBorder(BorderFactory.createLineBorder((int)2, (Color)Color.BLACK));
        box.setOpaque(true);
        LabelWidget label = new LabelWidget((Scene)this);
        label.setFont(this.getDefaultFont().deriveFont(0, 12.0f));
        label.setLabel(shortName);
        label.setBorder(BorderFactory.createEmptyBorder((int)6, (int)6, (int)0, (int)6));
        label.setAlignment(LabelWidget.Alignment.CENTER);
        box.addChild((Widget)label);
        label = new LabelWidget((Scene)this);
        label.setFont(this.getDefaultFont().deriveFont(0, 10.0f));
        label.setLabel(ViewHierarchyScene.getAddress(nodeName));
        label.setBorder(BorderFactory.createEmptyBorder((int)3, (int)6, (int)0, (int)6));
        label.setAlignment(LabelWidget.Alignment.CENTER);
        box.addressWidget = label;
        box.addChild((Widget)label);
        label = new LabelWidget((Scene)this);
        label.setFont(this.getDefaultFont().deriveFont(0, 10.0f));
        label.setLabel(id);
        label.setBorder(BorderFactory.createEmptyBorder((int)3, (int)6, (int)6, (int)6));
        label.setAlignment(LabelWidget.Alignment.CENTER);
        box.addChild((Widget)label);
        return box;
    }

    private static String getAddress(String name) {
        String[] nameAndHashcode = name.split("@");
        return "@" + nameAndHashcode[1];
    }

    private static String getShortName(String name) {
        String[] nameAndHashcode = name.split("@");
        String[] packages = nameAndHashcode[0].split("\\.");
        return packages[packages.length - 1];
    }

    protected Widget attachEdgeWidget(String edge) {
        ConnectionWidget connectionWidget = new ConnectionWidget((Scene)this);
        this.connectionLayer.addChild((Widget)connectionWidget);
        return connectionWidget;
    }

    protected void attachEdgeSourceAnchor(String edge, ViewNode oldSourceNode, ViewNode sourceNode) {
        ConnectionWidget connection = (ConnectionWidget)this.findWidget(edge);
        Widget source = this.findWidget(sourceNode);
        connection.bringToBack();
        source.bringToFront();
        connection.setSourceAnchor(AnchorFactory.createRectangularAnchor((Widget)source));
    }

    protected void attachEdgeTargetAnchor(String edge, ViewNode oldTargetNode, ViewNode targetNode) {
        ConnectionWidget connection = (ConnectionWidget)this.findWidget(edge);
        Widget target = this.findWidget(targetNode);
        connection.bringToBack();
        target.bringToFront();
        connection.setTargetAnchor(AnchorFactory.createRectangularAnchor((Widget)target));
    }

    private static class GradientWidget
    extends Widget
    implements ViewNode.StateListener {
        public static final GradientPaint BLUE_EXPERIENCE = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(168, 204, 241), new Point2D.Double(0.0, 1.0), new Color(44, 61, 146));
        public static final GradientPaint MAC_OSX_SELECTED = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(81, 141, 236), new Point2D.Double(0.0, 1.0), new Color(36, 96, 192));
        public static final GradientPaint MAC_OSX = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(167, 210, 250), new Point2D.Double(0.0, 1.0), new Color(99, 147, 206));
        public static final GradientPaint AERITH = new GradientPaint(new Point2D.Double(0.0, 0.0), Color.WHITE, new Point2D.Double(0.0, 1.0), new Color(64, 110, 161));
        public static final GradientPaint GRAY = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(226, 226, 226), new Point2D.Double(0.0, 1.0), new Color(250, 248, 248));
        public static final GradientPaint RED_XP = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(236, 81, 81), new Point2D.Double(0.0, 1.0), new Color(192, 36, 36));
        public static final GradientPaint NIGHT_GRAY = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(102, 111, 127), new Point2D.Double(0.0, 1.0), new Color(38, 45, 61));
        public static final GradientPaint NIGHT_GRAY_LIGHT = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(129, 138, 155), new Point2D.Double(0.0, 1.0), new Color(58, 66, 82));
        public static final GradientPaint NIGHT_GRAY_VERY_LIGHT = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(129, 138, 155, 60), new Point2D.Double(0.0, 1.0), new Color(58, 66, 82, 60));
        private static Color UNSELECTED = Color.BLACK;
        private static Color SELECTED = Color.WHITE;
        private final ViewNode node;
        private LabelWidget addressWidget;
        private boolean isSelected = false;
        private final GradientPaint selectedGradient = MAC_OSX_SELECTED;
        private final GradientPaint filteredGradient = RED_XP;
        private final GradientPaint focusGradient = NIGHT_GRAY_VERY_LIGHT;

        public GradientWidget(ViewHierarchyScene scene, ViewNode node) {
            super((Scene)scene);
            this.node = node;
            node.setStateListener(this);
        }

        protected void notifyStateChanged(ObjectState previous, ObjectState state) {
            super.notifyStateChanged(previous, state);
            this.isSelected = state.isSelected() || state.isFocused() || state.isWidgetFocused();
            this.pickChildrenColor();
        }

        private void pickChildrenColor() {
            for (Widget child : this.getChildren()) {
                child.setForeground(this.isSelected || this.node.filtered ? SELECTED : UNSELECTED);
            }
            this.repaint();
        }

        protected void paintBackground() {
            super.paintBackground();
            Graphics2D g2 = this.getGraphics();
            Rectangle bounds = this.getBounds();
            if (!this.isSelected) {
                if (!this.node.filtered) {
                    if (!this.node.hasFocus) {
                        g2.setColor(Color.WHITE);
                    } else {
                        g2.setPaint(new GradientPaint(bounds.x, bounds.y, this.focusGradient.getColor1(), bounds.x, bounds.x + bounds.height, this.focusGradient.getColor2()));
                    }
                } else {
                    g2.setPaint(new GradientPaint(bounds.x, bounds.y, this.filteredGradient.getColor1(), bounds.x, bounds.x + bounds.height, this.filteredGradient.getColor2()));
                }
            } else {
                g2.setPaint(new GradientPaint(bounds.x, bounds.y, this.selectedGradient.getColor1(), bounds.x, bounds.x + bounds.height, this.selectedGradient.getColor2()));
            }
            g2.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }

        public void nodeStateChanged(ViewNode node) {
            this.pickChildrenColor();
        }

        public void nodeIndexChanged(ViewNode node) {
            if (this.addressWidget != null) {
                this.addressWidget.setLabel("#" + node.index + this.addressWidget.getLabel());
            }
        }
    }
}

