/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.scene;

import com.android.ddmlib.IDevice;
import com.android.hierarchyviewer.device.DeviceBridge;
import com.android.hierarchyviewer.device.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

public class ProfilesLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] loadProfiles(IDevice device, Window window, String params) {
        Socket socket = null;
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress("127.0.0.1", DeviceBridge.getDeviceLocalPort(device)));
            out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.write("PROFILE " + window.encode() + " " + params);
            out.newLine();
            out.flush();
            String response = in.readLine();
            String[] data = response.split(" ");
            double[] profiles = new double[data.length];
            for (int i = 0; i < data.length; ++i) {
                profiles[i] = (double)Long.parseLong(data[i]) / 1000.0 / 1000.0;
            }
            double[] dArray = profiles;
            return dArray;
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }
}

