//
//  PSMPlayerProtocols.h
//  BombSquad
//
//  Created by John Pannell on 3/2/10.
//  Copyright 2010 Positive Spin Media. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@protocol PSMGameNodeDelegate

- (void)node:(id)node connectionWithPlayerFailed:(NSString *)playerID withError:(NSError *)error;
- (void)node:(id)node didFailWithError:(NSError *)error;
- (void)node:(id)node didReceiveConnectionRequestFromPlayer:(NSString *)playerID;
- (void)node:(id)node player:(NSString *)playerID didChangeState:(NSUInteger)state;

- (id)invocationTargetForSelector:(SEL)selector; // to get the method signature
- (id)forwardingTargetForSelector:(SEL)selector; // to send the message to the correct object
- (void)message:(NSString *)message toPlayer:(NSString *)playerID didFailWithError:(NSError *)error;

@end

