//
//  PSMGameNode.h
//  BombSquad
//
//  Created by John Pannell on 2/10/10.
//  Copyright 2010 Positive Spin Media. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "PSMPlayerDefinitions.h"
#import "PSMLanProtocols.h"
#import "PSMPlayerProtocols.h"

@interface PSMGameNode : NSObject <PSMLanSessionDelegate> {
    
    id <PSMGameNodeDelegate,NSObject>    delegate;
    
    NSString                    *displayName;
    
    NSMutableDictionary         *players;       // contains LAN and GK "players" which represent peers on the network
                                                // dictionary key is peerID
    NSMutableArray              *sessions;      // the LAN and/or GK sessions that maintain connections
    
    BOOL                        available;      // whether or not this node should appear on the network

}

@property (readwrite, assign) id delegate;
@property (readonly) NSString *displayName;
@property (readwrite) BOOL available;
@property (readonly) PSMGameNodeMode mode;

// creation/destruction
- (id)initWithCommonIdentifier:(NSString *)identifier displayName:(NSString *)name mode:(PSMGameNodeMode)mode;

// connecting to players
- (void)connectToPlayer:(NSString *)playerID withTimeout:(NSTimeInterval)timeout;
- (void)cancelConnectToPlayer:(NSString *)playerID;
- (BOOL)acceptConnectionFromPlayer:(NSString *)playerID error:(NSError **)error;
- (void)denyConnectionFromPlayer:(NSString *)playerID;
- (void)disconnectFromAllPlayers;
- (void)disconnectPlayerFromAllPlayers:(NSString *)playerID;

// usage
- (id)playerForPlayerID:(NSString *)playerID;   // fetch the player object to message it
- (NSString *)displayNameForPlayerID:(NSString *)playerID;



@end
