/*
 *  PSMLanProtocols.h
 *  BombSquad
 *
 *  Created by John Pannell on 2/16/10.
 *  Copyright 2010 Positive Spin Media. All rights reserved.
 *
 */

#import <Cocoa/Cocoa.h>

@class PSMLanListener;
@class PSMLanPeer;

@protocol PSMLanListenerDelegate

- (void)acceptedConnectionForListener:(PSMLanListener *)theListener
                          inputStream:(NSInputStream *)inStream
                         outputStream:(NSOutputStream *)outStream
                              address:(NSData *)address;

@optional

- (void)lanListener:(PSMLanListener *)theListener encounteredError:(NSError *)error;

@end

@protocol PSMLanPeerDelegate

- (void)peer:(PSMLanPeer *)peer didChangeState:(NSUInteger)newState;
- (void)peerDidReceiveConnectionRequest:(PSMLanPeer *)peer;
- (void)connectionRequestWithPeerFailed:(PSMLanPeer *)peer withError:(NSError *)error;
- (void)peer:(PSMLanPeer *)peer receivedData:(NSData *)data;
- (void)peer:(PSMLanPeer *)peer encounteredReadWriteError:(NSError *)error;

@end

@protocol PSMLanSessionDelegate

- (void)session:(id)session connectionWithPeerFailed:(NSString *)peerID withError:(NSError *)error;
- (void)session:(id)session didFailWithError:(NSError *)error;
- (void)session:(id)session didReceiveConnectionRequestFromPeer:(NSString *)peerID;
- (void)session:(id)session peer:(NSString *)peerID didChangeState:(NSUInteger)state;
- (void)receiveData:(NSData *)data fromPeer:(NSString *)peer inSession:(id)session context:(void *)context;

@end