/*
 *  PSMLanDefinitions.h
 *  BombSquad
 *
 *  Created by John Pannell on 2/16/10.
 *  Copyright 2010 Positive Spin Media. All rights reserved.
 *
 */

// the various connection states that a peer can be in at a given time
typedef enum {
    PSMLanPeerStateAvailable,
    PSMLanPeerStateUnavailable,
    PSMLanPeerStateConnected,
    PSMLanPeerStateDisconnected,
    PSMLanPeerStateConnecting
} PSMLanPeerConnectionState;

// the types of sessions that can be created with a LAN session object
typedef enum {
    PSMLanSessionModeServer,
    PSMLanSessionModeClient,
    PSMLanSessionModePeer,
} PSMLanSessionMode;

// the ways to send data through socket streams
typedef enum {
    PSMLanSendDataReliable,
    PSMLanSendDataUnreliable,
} PSMLanSendDataMode;

// uint8_t encodings for peer messaging
enum {
    kPSMPeerMessageExternal,    // sends message data along - normal route
    kPSMPeerMessageSetErrorCode,
    kPSMPeerMessageAcceptRemoteConnection,
    kPSMPeerMessageDenyRemoteConnection,
    kPSMPeerMessageKickOutRemote,
    kPSMPeerMessageDisconnect,
    kPSMPeerMessageACKRequest,
    kPSMPeerMessageACKResponse
};

static NSString* const PSMLanSessionErrorDomain = @"PSMLanSessionErrorDomain";

enum {
    PSMLanSessionInvalidParameterError = 30500,
    PSMLanSessionPeerNotFoundError = 30501,
    PSMLanSessionDeclinedError = 30502,
    PSMLanSessionTimedOutError = 30503,
    PSMLanSessionCancelledError = 30504,
    PSMLanSessionConnectionFailedError = 30505,
    PSMLanSessionConnectionClosedError = 30506,
    PSMLanSessionDataTooBigError = 30507,
    PSMLanSessionNotConnectedError = 30508,
    PSMLanSessionCannotEnableError = 30509,
    PSMLanSessionInProgressError = 30510,
    PSMLanSessionConnectivityError = 30201,
    PSMLanSessionTransportError = 30202,
    PSMLanSessionInternalError = 30203,
    PSMLanSessionUnknownError = 30204,
    PSMLanSessionSystemError = 30205
};