/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet;

import java.util.Collection;
import java.util.HashSet;
import javax.servlet.HttpConstraintElement;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.ServletSecurity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletSecurityElement
extends HttpConstraintElement {
    private Collection<String> _methodNames = new HashSet<String>(0);
    private Collection<HttpMethodConstraintElement> _httpMethodConstraints = new HashSet<HttpMethodConstraintElement>(0);

    public ServletSecurityElement() {
    }

    public ServletSecurityElement(HttpConstraintElement constraint) {
        super(constraint.getEmptyRoleSemantic(), constraint.getTransportGuarantee(), constraint.getRolesAllowed());
    }

    public ServletSecurityElement(Collection<HttpMethodConstraintElement> methodConstraints) {
        this(new HttpConstraintElement(), methodConstraints);
    }

    public ServletSecurityElement(HttpConstraintElement constraint, Collection<HttpMethodConstraintElement> methodConstraints) {
        this(constraint);
        this._methodNames = new HashSet<String>(methodConstraints.size());
        for (HttpMethodConstraintElement methodConstraint : methodConstraints) {
            String httpMethod = methodConstraint.getMethodName();
            if (this._methodNames.contains(httpMethod)) {
                throw new IllegalArgumentException("Http method " + httpMethod + " was already used.");
            }
            this._methodNames.add(httpMethod);
        }
        this._httpMethodConstraints.addAll(methodConstraints);
    }

    public ServletSecurityElement(ServletSecurity annotation) {
        super(annotation.value().value(), annotation.value().transportGuarantee(), annotation.value().rolesAllowed());
        HttpMethodConstraint[] methodConstraints;
        for (HttpMethodConstraint methodConstraint : methodConstraints = annotation.httpMethodConstraints()) {
            String httpMethod = methodConstraint.value();
            if (this._methodNames.contains(httpMethod)) {
                throw new IllegalArgumentException("Http method " + httpMethod + " was already used.");
            }
            this._methodNames.add(httpMethod);
            HttpMethodConstraintElement methodConstraintElement = new HttpMethodConstraintElement(httpMethod, new HttpConstraintElement(methodConstraint.emptyRoleSemantic(), methodConstraint.transportGuarantee(), methodConstraint.rolesAllowed()));
            this._httpMethodConstraints.add(methodConstraintElement);
        }
    }

    public Collection<HttpMethodConstraintElement> getHttpMethodConstraints() {
        return this._httpMethodConstraints;
    }

    public Collection<String> getMethodNames() {
        return this._methodNames;
    }
}

