/*
 * Decompiled with CFR 0.152.
 */
package javax.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class TopicRequestor {
    private TopicSession _session;
    private Topic _topic;
    private TopicPublisher _sender;

    public TopicRequestor(TopicSession session, Topic topic) throws JMSException {
        this._session = session;
        this._topic = topic;
        this._sender = this._session.createPublisher(topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message request(Message message) throws JMSException {
        TemporaryTopic tempTopic = this._session.createTemporaryTopic();
        try {
            Message message2;
            message.setJMSReplyTo(tempTopic);
            this._sender.publish(message);
            TopicSubscriber receiver = this._session.createSubscriber(tempTopic);
            try {
                message2 = receiver.receive();
            }
            catch (Throwable throwable) {
                receiver.close();
                throw throwable;
            }
            receiver.close();
            return message2;
        }
        finally {
            tempTopic.delete();
        }
    }

    public void close() throws JMSException {
        this._sender.close();
        this._session.close();
    }
}

