/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapELResolver
extends ELResolver {
    private static final Logger log = Logger.getLogger(MapELResolver.class.getName());
    private final boolean _isReadOnly;

    public MapELResolver() {
        this._isReadOnly = false;
    }

    public MapELResolver(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base instanceof Map) {
            context.setPropertyResolved(true);
            return Object.class;
        }
        return null;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base instanceof Map) {
            context.setPropertyResolved(true);
            ArrayList<FeatureDescriptor> keys = new ArrayList<FeatureDescriptor>();
            for (Object key : ((Map)base).keySet()) {
                String name = String.valueOf(key);
                FeatureDescriptor desc = new FeatureDescriptor();
                desc.setName(name);
                desc.setDisplayName(name);
                desc.setShortDescription("");
                desc.setExpert(false);
                desc.setHidden(false);
                desc.setPreferred(true);
                if (key == null) {
                    desc.setValue("type", null);
                } else {
                    desc.setValue("type", key.getClass());
                }
                desc.setValue("resolvableAtDesignTime", Boolean.TRUE);
                keys.add(desc);
            }
            return keys.iterator();
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof Map) {
            context.setPropertyResolved(true);
            return Object.class;
        }
        return null;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (base instanceof Map && property != null) {
            Map map = (Map)base;
            context.setPropertyResolved(true);
            return map.get(property);
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base instanceof Map) {
            context.setPropertyResolved(true);
            return this._isReadOnly;
        }
        return true;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (this._isReadOnly) {
            throw new PropertyNotWritableException("resolver is readonly");
        }
        if (base instanceof Map && property != null) {
            Map map = (Map)base;
            context.setPropertyResolved(true);
            try {
                map.put(property, value);
            }
            catch (UnsupportedOperationException e) {
                throw new PropertyNotWritableException("map " + base + " of type " + map.getClass().getName() + " is umodifiable");
            }
        }
    }
}

