/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeELResolver
extends ELResolver {
    private final ArrayList<ELResolver> _resolvers = new ArrayList();

    public void add(ELResolver elResolver) {
        if (elResolver == null) {
            throw new NullPointerException();
        }
        this._resolvers.add(elResolver);
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext env, Object base) {
        Class<?> commonClass = null;
        int size = this._resolvers.size();
        for (int i = 0; i < size; ++i) {
            ELResolver resolver = this._resolvers.get(i);
            Class<?> cl = resolver.getCommonPropertyType(env, base);
            if (cl == null) continue;
            commonClass = cl;
        }
        return commonClass;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext env, Object base) {
        ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>();
        int size = this._resolvers.size();
        for (int i = 0; i < size; ++i) {
            ELResolver resolver = this._resolvers.get(i);
            Iterator<FeatureDescriptor> iter = resolver.getFeatureDescriptors(env, base);
            if (iter == null) continue;
            while (iter.hasNext()) {
                FeatureDescriptor desc = iter.next();
                descriptors.add(desc);
            }
        }
        return descriptors.iterator();
    }

    @Override
    public Class<?> getType(ELContext env, Object base, Object property) {
        env.setPropertyResolved(false);
        int size = this._resolvers.size();
        for (int i = 0; i < size; ++i) {
            ELResolver resolver = this._resolvers.get(i);
            Class<?> type = resolver.getType(env, base, property);
            if (!env.isPropertyResolved()) continue;
            return type;
        }
        return null;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        int size = this._resolvers.size();
        for (int i = 0; i < size; ++i) {
            ELResolver resolver = this._resolvers.get(i);
            Object value = resolver.getValue(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return value;
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        int size = this._resolvers.size();
        for (int i = 0; i < size; ++i) {
            ELResolver resolver = this._resolvers.get(i);
            boolean value = resolver.isReadOnly(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return value;
        }
        return true;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        context.setPropertyResolved(false);
        int size = this._resolvers.size();
        for (int i = 0; i < size; ++i) {
            ELResolver resolver = this._resolvers.get(i);
            resolver.setValue(context, base, property, value);
            if (!context.isPropertyResolved()) continue;
            return;
        }
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        context.setPropertyResolved(false);
        int size = this._resolvers.size();
        for (int i = 0; i < size; ++i) {
            ELResolver resolver = this._resolvers.get(i);
            Object value = resolver.invoke(context, base, method, paramTypes, params);
            if (!context.isPropertyResolved()) continue;
            return value;
        }
        return null;
    }
}

