/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanELResolver
extends ELResolver {
    private static WeakHashMap<Class<?>, SoftReference<BeanProperties>> _classMap = new WeakHashMap();
    private final boolean _isReadOnly;

    public BeanELResolver() {
        this._isReadOnly = false;
    }

    public BeanELResolver(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        return Object.class;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        Class<?> cl = base.getClass();
        BeanProperties props = BeanELResolver.getProps(cl);
        if (props == null) {
            if (cl.isArray() || Collection.class.isAssignableFrom(cl) || Map.class.isAssignableFrom(cl)) {
                return null;
            }
            props = new BeanProperties(cl);
            BeanELResolver.setProps(cl, props);
        }
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        for (BeanProperty prop : props.getProperties()) {
            descriptors.add(prop.getDescriptor());
        }
        return descriptors.iterator();
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base == null || property == null) {
            return null;
        }
        if (!(property instanceof String)) {
            return null;
        }
        String fieldName = (String)property;
        if (fieldName.length() == 0) {
            return null;
        }
        Class<?> cl = base.getClass();
        BeanProperties props = BeanELResolver.getProps(cl);
        if (props == null) {
            if (cl.isArray() || Collection.class.isAssignableFrom(cl) || Map.class.isAssignableFrom(cl)) {
                return null;
            }
            props = new BeanProperties(cl);
            BeanELResolver.setProps(cl, props);
        }
        BeanProperty prop = props.getBeanProperty(fieldName);
        context.setPropertyResolved(true);
        if (prop != null) {
            if (prop.getWriteMethod() != null) {
                return prop.getWriteMethod().getParameterTypes()[0];
            }
            if (prop.getReadMethod() != null) {
                return prop.getReadMethod().getReturnType();
            }
        }
        throw new PropertyNotFoundException("'" + property + "' is an unknown bean property of '" + base.getClass().getName() + "'");
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null || property == null) {
            return null;
        }
        String fieldName = String.valueOf(property);
        if (fieldName.length() == 0) {
            return null;
        }
        Class<?> cl = base.getClass();
        BeanProperties props = BeanELResolver.getProps(cl);
        if (props == null) {
            if (cl.isArray() || Collection.class.isAssignableFrom(cl) || Map.class.isAssignableFrom(cl)) {
                return null;
            }
            props = new BeanProperties(cl);
            BeanELResolver.setProps(cl, props);
        }
        BeanProperty prop = props.getBeanProperty(fieldName);
        context.setPropertyResolved(true);
        if (prop == null || prop.getReadMethod() == null) {
            throw new PropertyNotFoundException("'" + property + "' is an unknown bean property of '" + base.getClass().getName() + "'");
        }
        try {
            return prop.getReadMethod().invoke(base, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ELException(e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(e.getCause());
        }
    }

    @Override
    public boolean isReadOnly(ELContext env, Object base, Object property) {
        if (base == null) {
            return false;
        }
        BeanProperties props = this.getProp(env, base, property);
        if (props != null) {
            env.setPropertyResolved(true);
            if (this._isReadOnly) {
                return true;
            }
            BeanProperty prop = props.getBeanProperty((String)property);
            if (prop != null) {
                return prop.isReadOnly();
            }
        }
        throw new PropertyNotFoundException("'" + property + "' is an unknown bean property of '" + base.getClass().getName() + "'");
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base == null || property == null) {
            return;
        }
        String fieldName = String.valueOf(property);
        if (fieldName.length() == 0) {
            return;
        }
        Class<?> cl = base.getClass();
        BeanProperties props = BeanELResolver.getProps(cl);
        if (props == null) {
            if (cl.isArray() || Collection.class.isAssignableFrom(cl) || Map.class.isAssignableFrom(cl)) {
                return;
            }
            props = new BeanProperties(cl);
            BeanELResolver.setProps(cl, props);
        }
        BeanProperty prop = props.getBeanProperty(fieldName);
        context.setPropertyResolved(true);
        if (prop == null) {
            throw new PropertyNotFoundException(fieldName);
        }
        if (this._isReadOnly || prop.getWriteMethod() == null) {
            throw new PropertyNotWritableException(fieldName);
        }
        Method writeMethod = prop.getWriteMethod();
        Class<?> type = writeMethod.getParameterTypes()[0];
        if (value != null && type.isEnum() && !type.isAssignableFrom(value.getClass())) {
            value = Enum.valueOf(type, String.valueOf(value));
        }
        try {
            writeMethod.invoke(base, value);
        }
        catch (IllegalAccessException e) {
            throw new ELException(e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(e.getCause());
        }
    }

    @Override
    public Object invoke(ELContext context, Object base, Object methodObj, Class<?>[] paramTypes, Object[] params) {
        if (base == null) {
            throw new ELException("base object is null");
        }
        String methodName = methodObj instanceof String ? (String)methodObj : (methodObj instanceof Enum ? ((Enum)methodObj).name() : methodObj.toString());
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        Method method = null;
        try {
            method = base.getClass().getDeclaredMethod(methodName, paramTypes);
            try {
                Object result = method.invoke(base, params);
                context.setPropertyResolved(true);
                return result;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw new ELException(cause);
            }
        }
        catch (NoSuchMethodException e) {
            throw new MethodNotFoundException("method '" + e.getMessage() + "' not found", e);
        }
        catch (Exception e) {
            throw new ELException("failed to invoke method '" + method + "'", e);
        }
    }

    private BeanProperties getProp(ELContext context, Object base, Object property) {
        if (base == null || !(property instanceof String)) {
            return null;
        }
        String fieldName = (String)property;
        if (fieldName.length() == 0) {
            return null;
        }
        Class<?> cl = base.getClass();
        BeanProperties props = BeanELResolver.getProps(cl);
        if (props == null) {
            if (cl.isArray() || Collection.class.isAssignableFrom(cl) || Map.class.isAssignableFrom(cl)) {
                return null;
            }
            props = new BeanProperties(cl);
            BeanELResolver.setProps(cl, props);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BeanProperties getProps(Class<?> cl) {
        WeakHashMap<Class<?>, SoftReference<BeanProperties>> weakHashMap = _classMap;
        synchronized (weakHashMap) {
            SoftReference<BeanProperties> ref = _classMap.get(cl);
            if (ref != null) {
                return ref.get();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setProps(Class<?> cl, BeanProperties props) {
        WeakHashMap<Class<?>, SoftReference<BeanProperties>> weakHashMap = _classMap;
        synchronized (weakHashMap) {
            _classMap.put(cl, new SoftReference<BeanProperties>(props));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BeanProperty {
        private Class<?> _base;
        private PropertyDescriptor _descriptor;
        private Method _readMethod;
        private Method _writeMethod;
        private boolean _isInit;

        public BeanProperty(Class<?> baseClass, PropertyDescriptor descriptor) {
            this._base = baseClass;
            this._descriptor = descriptor;
            Method readMethod = descriptor.getReadMethod();
            try {
                if (readMethod != null) {
                    this._readMethod = this._base.getMethod(readMethod.getName(), readMethod.getParameterTypes());
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (this._readMethod != null) {
                this._readMethod.setAccessible(true);
            }
            this._writeMethod = descriptor.getWriteMethod();
            if (this._writeMethod != null) {
                this._writeMethod.setAccessible(true);
            }
        }

        private BeanProperty(Class<?> baseClass, String name, Method getter, Method setter) {
            try {
                this._base = baseClass;
                this._descriptor = getter != null && !Void.TYPE.equals(getter.getReturnType()) ? new PropertyDescriptor(name, getter, setter) : new PropertyDescriptor(name, null, null);
                if (getter != null) {
                    this._readMethod = this._base.getMethod(getter.getName(), getter.getParameterTypes());
                }
                if (this._readMethod != null) {
                    this._readMethod.setAccessible(true);
                }
                this._writeMethod = setter;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        void initDescriptor() {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
            Method readMethod = this._readMethod;
            if (readMethod != null) {
                this._descriptor.setValue("type", readMethod.getReturnType());
            }
            this._descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        }

        private PropertyDescriptor getDescriptor() {
            this.initDescriptor();
            return this._descriptor;
        }

        public Class<?> getPropertyType() {
            return this._descriptor.getPropertyType();
        }

        public Method getReadMethod() {
            return this._readMethod;
        }

        public Method getWriteMethod() {
            return this._writeMethod;
        }

        public boolean isReadOnly() {
            return this.getWriteMethod() == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BeanProperties {
        private HashMap<String, BeanProperty> _propMap = new HashMap();

        public BeanProperties(Class<?> baseClass) {
            try {
                BeanInfo info = Introspector.getBeanInfo(baseClass);
                for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                    this._propMap.put(descriptor.getName(), new BeanProperty(baseClass, descriptor));
                }
                Method[] methods = baseClass.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    String propName;
                    Method method = methods[i];
                    String name = method.getName();
                    if (method.getParameterTypes().length != 0 || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
                    if (name.startsWith("get")) {
                        propName = Introspector.decapitalize(name.substring(3));
                    } else {
                        if (!name.startsWith("is")) continue;
                        propName = Introspector.decapitalize(name.substring(2));
                    }
                    BeanProperty oldProp = this._propMap.get(propName);
                    if (oldProp == null) {
                        this._propMap.put(propName, new BeanProperty(baseClass, propName, method, null));
                        continue;
                    }
                    if (oldProp != null && method.equals(oldProp.getReadMethod())) continue;
                    this._propMap.put(propName, new BeanProperty(baseClass, propName, method, null));
                }
            }
            catch (IntrospectionException e) {
                throw new ELException(e);
            }
        }

        public BeanProperty getBeanProperty(String property) {
            return this._propMap.get(property);
        }

        private Collection<BeanProperty> getProperties() {
            return this._propMap.values();
        }
    }
}

