/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.XPath;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.XPathParseException;
import java.util.Comparator;
import org.w3c.dom.Node;

public class Sort {
    public static final int NO_CASE_ORDER = 0;
    public static final int UPPER_FIRST = 1;
    public static final int LOWER_FIRST = 2;
    private Expr _expr;
    private boolean _isText;
    private Expr _isAscending;
    private Expr _caseOrder;
    private Expr _lang;

    Sort(Expr expr, Expr isAscending, boolean isText) {
        this._expr = expr;
        this._isAscending = isAscending;
        this._isText = isText;
    }

    Sort(Expr expr, Expr isAscending, Expr lang) {
        this._expr = expr;
        this._isAscending = isAscending;
        this._isText = true;
        this._lang = lang;
    }

    public Sort(String expr, String isAscending, boolean isText) throws XPathParseException {
        this._expr = XPath.parseExpr(expr);
        if (isAscending != null) {
            this._isAscending = XPath.parseExpr(isAscending);
        }
        this._isText = isText;
    }

    public Sort(String expr, String isAscending, String lang) throws XPathParseException {
        this._expr = XPath.parseExpr(expr);
        if (isAscending != null) {
            this._isAscending = XPath.parseExpr(isAscending);
        }
        this._lang = XPath.parseExpr(lang);
        this._isText = true;
    }

    public Sort(String expr, String isAscending, String lang, String caseOrder) throws XPathParseException {
        this._expr = XPath.parseExpr(expr);
        if (isAscending != null) {
            this._isAscending = XPath.parseExpr(isAscending);
        }
        if (lang != null) {
            this._lang = XPath.parseExpr(lang);
        }
        this._isText = true;
        if (caseOrder != null) {
            this._caseOrder = XPath.parseExpr(caseOrder);
        }
    }

    public static Sort create(Expr expr, Expr isAscending, boolean isText) {
        return new Sort(expr, isAscending, isText);
    }

    public static Sort create(Expr expr, Expr isAscending, Expr lang) {
        return new Sort(expr, isAscending, lang);
    }

    public Expr getExpr() {
        return this._expr;
    }

    public Expr getAscending() {
        return this._isAscending;
    }

    public void setCaseOrder(Expr caseOrder) {
        this._caseOrder = caseOrder;
    }

    public Expr getCaseOrder() {
        return this._caseOrder;
    }

    public boolean isText() {
        return this._isText;
    }

    public Expr getLang() {
        return this._lang;
    }

    Object sortValue(Node child, Env env) throws XPathException {
        if (this._isText) {
            return this._expr.evalString(child, env);
        }
        return new Double(this._expr.evalNumber(child, env));
    }

    int cmp(Object a, Object b, Comparator comparator, boolean isAscending, int caseOrder) {
        if (comparator != null) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return isAscending ? -1 : 1;
            }
            if (b == null) {
                return isAscending ? 1 : -1;
            }
            int cmp = comparator.compare(a, b);
            return isAscending ? cmp : -cmp;
        }
        if (!this._isText) {
            double db;
            double da = (Double)a;
            if (da == (db = ((Double)b).doubleValue())) {
                return 0;
            }
            if (da < db) {
                return isAscending ? -1 : 1;
            }
            if (db < da) {
                return isAscending ? 1 : -1;
            }
            if (!Double.isNaN(da)) {
                return isAscending ? -1 : 1;
            }
            if (!Double.isNaN(db)) {
                return isAscending ? 1 : -1;
            }
            return 0;
        }
        String va = (String)a;
        String vb = (String)b;
        if (va == vb) {
            return 0;
        }
        if (va == null) {
            return isAscending ? -1 : 1;
        }
        if (vb == null) {
            return isAscending ? 1 : -1;
        }
        int cmp = 0;
        if (caseOrder == 0) {
            cmp = va.compareTo(vb);
        } else if (caseOrder == 1) {
            int i;
            int len = va.length();
            if (vb.length() < len) {
                len = vb.length();
            }
            for (i = 0; i < len; ++i) {
                char chB;
                char chA = va.charAt(i);
                if (chA == (chB = vb.charAt(i))) continue;
                if (Character.isUpperCase(chA) && Character.isLowerCase(chB)) {
                    cmp = -1;
                    break;
                }
                if (Character.isLowerCase(chA) && Character.isUpperCase(chB)) {
                    cmp = 1;
                    break;
                }
                cmp = chA - chB;
                break;
            }
            if (i >= len) {
                cmp = va.length() == vb.length() ? 0 : (va.length() < vb.length() ? -1 : 1);
            }
        } else if (caseOrder == 2) {
            int i;
            int len = va.length();
            if (vb.length() < len) {
                len = vb.length();
            }
            for (i = 0; i < len; ++i) {
                char chB;
                char chA = va.charAt(i);
                if (chA == (chB = vb.charAt(i))) continue;
                if (Character.isUpperCase(chA) && Character.isLowerCase(chB)) {
                    cmp = 1;
                    break;
                }
                if (Character.isLowerCase(chA) && Character.isUpperCase(chB)) {
                    cmp = -1;
                    break;
                }
                cmp = chA - chB;
                break;
            }
            if (i >= len) {
                cmp = va.length() == vb.length() ? 0 : (va.length() < vb.length() ? -1 : 1);
            }
        }
        return isAscending ? cmp : -cmp;
    }
}

