/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.util.CharBuffer;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.NodeArrayListIterator;
import com.caucho.xpath.pattern.NodeIterator;
import com.caucho.xpath.pattern.NodeListIterator;
import com.caucho.xpath.pattern.SingleNodeIterator;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Var {
    boolean getBoolean() throws XPathException {
        return Expr.toBoolean(this.getObject());
    }

    double getDouble() throws XPathException {
        Object o = this.getObject();
        return Expr.toDouble(this.getObject());
    }

    String getString() throws XPathException {
        return Expr.toString(this.getObject());
    }

    void getString(CharBuffer cb) throws XPathException {
        cb.append(this.getString());
    }

    NodeIterator getNodeSet(ExprEnvironment env) throws XPathException {
        Object obj = this.getObject();
        if (obj instanceof Node) {
            return new SingleNodeIterator(env, (Node)obj);
        }
        if (obj instanceof NodeList) {
            return new NodeListIterator(env, (NodeList)obj);
        }
        if (obj instanceof ArrayList) {
            return new NodeArrayListIterator(env, (ArrayList)obj);
        }
        return new SingleNodeIterator(env, null);
    }

    abstract Object getObject();

    public void free() {
    }
}

