/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.util.CharBuffer;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.w3c.dom.Node;

public class StaticJavaExpr
extends Expr {
    private static final int J_BOOLEAN = 1;
    private static final int J_BYTE = 2;
    private static final int J_SHORT = 3;
    private static final int J_INT = 4;
    private static final int J_LONG = 5;
    private static final int J_FLOAT = 6;
    private static final int J_DOUBLE = 7;
    private static final int J_STRING = 8;
    private static final int J_OBJECT = 9;
    private Method _method;
    private ArrayList args;
    private int[] argTypes;
    private int retType;

    public StaticJavaExpr(Method method, ArrayList args) {
        this._method = method;
        this.args = args;
        this.argTypes = new int[args.size()];
        Class<?>[] paramClasses = this._method.getParameterTypes();
        for (int i = 0; i < paramClasses.length; ++i) {
            this.argTypes[i] = this.classToType(paramClasses[i]);
        }
        this.retType = this.classToType(this._method.getReturnType());
    }

    private int classToType(Class cl) {
        if (Boolean.TYPE.equals(cl) || Boolean.class.equals((Object)cl)) {
            return 1;
        }
        if (Byte.TYPE.equals(cl) || Byte.class.equals((Object)cl)) {
            return 2;
        }
        if (Short.TYPE.equals(cl) || Short.class.equals((Object)cl)) {
            return 3;
        }
        if (Integer.TYPE.equals(cl) || Integer.class.equals((Object)cl)) {
            return 4;
        }
        if (Long.TYPE.equals(cl) || Long.class.equals((Object)cl)) {
            return 5;
        }
        if (Float.TYPE.equals(cl) || Float.class.equals((Object)cl)) {
            return 6;
        }
        if (Double.TYPE.equals(cl) || Double.class.equals((Object)cl)) {
            return 7;
        }
        if (String.class.equals((Object)cl)) {
            return 8;
        }
        return 9;
    }

    public boolean isString() {
        return this.retType == 8;
    }

    public boolean isBoolean() {
        return this.retType == 1;
    }

    public boolean isNumber() {
        return this.retType >= 2 && this.retType <= 7;
    }

    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        Object value = this.evalObject(node, env);
        return String.valueOf(value);
    }

    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        return StaticJavaExpr.toBoolean(this.evalObject(node, env));
    }

    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        return StaticJavaExpr.toDouble(this.evalObject(node, env));
    }

    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        Object[] argArray = new Object[this.args.size()];
        block12: for (int i = 0; i < argArray.length; ++i) {
            Expr expr = (Expr)this.args.get(i);
            switch (this.argTypes[i]) {
                case 1: {
                    argArray[i] = new Boolean(expr.evalBoolean(node, env));
                    continue block12;
                }
                case 2: {
                    argArray[i] = new Byte((byte)expr.evalNumber(node, env));
                    continue block12;
                }
                case 3: {
                    argArray[i] = new Short((short)expr.evalNumber(node, env));
                    continue block12;
                }
                case 4: {
                    argArray[i] = new Integer((int)expr.evalNumber(node, env));
                    continue block12;
                }
                case 5: {
                    argArray[i] = new Long((long)expr.evalNumber(node, env));
                    continue block12;
                }
                case 6: {
                    argArray[i] = new Float((float)expr.evalNumber(node, env));
                    continue block12;
                }
                case 7: {
                    argArray[i] = new Double(expr.evalNumber(node, env));
                    continue block12;
                }
                case 8: {
                    argArray[i] = expr.evalString(node, env);
                    continue block12;
                }
                default: {
                    argArray[i] = expr.evalObject(node, env);
                }
            }
        }
        try {
            return this._method.invoke(null, argArray);
        }
        catch (Exception e) {
            throw new XPathException(e);
        }
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("java:");
        cb.append(this._method.getDeclaringClass().getName());
        cb.append(".");
        cb.append(this._method.getName());
        cb.append("(");
        for (int i = 0; i < this.args.size(); ++i) {
            if (i != 0) {
                cb.append(",");
            }
            cb.append(this.args.get(i));
        }
        cb.append(")");
        return cb.close();
    }
}

