/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml2.readers;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.ReadStream;
import com.caucho.xml2.XmlParser;
import com.caucho.xml2.readers.XmlReader;
import java.io.IOException;

public class MacroReader
extends XmlReader {
    char[] _buffer = new char[256];
    int _offset;
    int _length;

    public void init(XmlParser parser, XmlReader next) {
        this._parser = parser;
        this._next = next;
        this._offset = 0;
        this._length = 0;
    }

    public ReadStream getReadStream() {
        return this._next.getReadStream();
    }

    public String getSystemId() {
        if (this._next != null) {
            return this._next.getSystemId();
        }
        return super.getSystemId();
    }

    public String getPublicId() {
        if (this._next != null) {
            return this._next.getPublicId();
        }
        return super.getPublicId();
    }

    public String getFilename() {
        if (this._next != null) {
            return this._next.getFilename();
        }
        return super.getFilename();
    }

    public int getLine() {
        if (this._next != null) {
            return this._next.getLine();
        }
        return super.getLine();
    }

    public void add(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.add(s.charAt(i));
        }
    }

    public void add(CharBuffer cb) {
        int len = cb.length();
        for (int i = 0; i < len; ++i) {
            this.add(cb.charAt(i));
        }
    }

    public void add(char ch) {
        if (this._offset == this._length) {
            this._offset = 0;
            this._length = 0;
        }
        if (this._buffer.length == this._length) {
            char[] newBuffer = new char[2 * this._buffer.length];
            System.arraycopy(this._buffer, 0, newBuffer, 0, this._length);
            this._buffer = newBuffer;
        }
        this._buffer[this._length++] = ch;
    }

    public void prepend(char ch) {
        if (this._offset == this._length) {
            this._offset = 0;
            this._length = 0;
        }
        if (this._buffer.length == this._length) {
            char[] newBuffer = new char[2 * this._buffer.length];
            System.arraycopy(this._buffer, 0, newBuffer, 0, this._length);
            this._buffer = newBuffer;
        }
        for (int i = this._length; i >= 0; --i) {
            this._buffer[i + 1] = this._buffer[i];
        }
        ++this._length;
        this._buffer[0] = ch;
    }

    public int read() throws IOException {
        if (this._offset < this._length) {
            return this._buffer[this._offset++];
        }
        return this._next.read();
    }
}

