/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml2;

import com.caucho.xml2.NamespaceBinding;
import com.caucho.xml2.SaxIntern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class NamespaceContextImpl {
    private final HashMap<String, NamespaceBinding> _bindings = new HashMap();
    private ElementBinding[] _stack = new ElementBinding[32];
    private int _stackTop = 1;
    private NamespaceBinding _nullEltBinding = new NamespaceBinding(null, null, 0);
    private NamespaceBinding _nullAttrBinding = new NamespaceBinding(null, null, 0);
    private int _uniqueId = 0;
    private int _version = 0;

    NamespaceContextImpl() {
    }

    public void push(SaxIntern.Entry entry) {
        ElementBinding elt = this._stack[this._stackTop];
        if (elt == null) {
            this._stack[this._stackTop] = elt = new ElementBinding();
        }
        ++this._stackTop;
        elt.setName(entry);
    }

    public void pop(SaxIntern.Entry entry) {
        ElementBinding eltBinding;
        if ((eltBinding = this._stack[--this._stackTop]) != null) {
            ArrayList<Decl> oldBinding = eltBinding.getOldBindingList();
            for (int i = 0; oldBinding != null && i < oldBinding.size(); ++i) {
                Decl decl = oldBinding.get(i);
                NamespaceBinding binding = decl.getBinding();
                ++this._version;
                binding.setUri(decl.getOldUri());
                binding.setVersion(this._version);
            }
            eltBinding.clear();
        }
    }

    public int getDepth() {
        return this._stackTop - 1;
    }

    public void declare(String prefix, String uri) {
        NamespaceBinding binding = this.getElementNamespace(prefix);
        ElementBinding eltBinding = this._stack[this._stackTop - 1];
        if (eltBinding == null) {
            this._stack[this._stackTop - 1] = eltBinding = new ElementBinding();
        }
        eltBinding.addOldBinding(binding, prefix, binding.getUri(), uri);
        ++this._version;
        binding.setUri(uri);
        binding.setVersion(this._version);
    }

    public String declare(String uri) {
        String prefix = "ns" + this._uniqueId++;
        this.declare(prefix, uri);
        return prefix;
    }

    public String getUri(String prefix) {
        NamespaceBinding binding = this._bindings.get(prefix);
        if (binding != null) {
            return binding.getUri();
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        NamespaceBinding binding = this._bindings.get(prefix);
        if (binding != null) {
            return binding.getUri();
        }
        String uri = null;
        if ("xml".equals(prefix)) {
            uri = "http://www.w3.org/XML/1998/namespace";
        } else if ("xmlns".equals(prefix)) {
            uri = "http://www.w3.org/2000/xmlns/";
        }
        return uri;
    }

    public Iterator getPrefixes(String uri) {
        return null;
    }

    public String getUri(int i) {
        ElementBinding eltBinding = this._stack[this._stackTop - 1];
        if (eltBinding != null) {
            return eltBinding.getOldBindingList().get(i).getNewUri();
        }
        return null;
    }

    public String getPrefix(int i) {
        ElementBinding eltBinding = this._stack[this._stackTop - 1];
        if (eltBinding != null) {
            return eltBinding.getOldBindingList().get(i).getPrefix();
        }
        return null;
    }

    public int getNumDecls() {
        ElementBinding eltBinding = this._stack[this._stackTop - 1];
        if (eltBinding != null) {
            return eltBinding.getOldBindingList().size();
        }
        return 0;
    }

    NamespaceBinding getElementNamespace(String prefix) {
        NamespaceBinding binding = prefix == null ? this._nullEltBinding : this._bindings.get(prefix);
        if (binding != null) {
            return binding;
        }
        binding = new NamespaceBinding(prefix, null, this._version);
        this._bindings.put(prefix, binding);
        return binding;
    }

    NamespaceBinding getAttributeNamespace(String prefix) {
        NamespaceBinding binding = prefix == null ? this._nullAttrBinding : this._bindings.get(prefix);
        if (binding != null) {
            return binding;
        }
        binding = new NamespaceBinding(prefix, null, this._version);
        this._bindings.put(prefix, binding);
        return binding;
    }

    static class Decl {
        private final NamespaceBinding _binding;
        private final String _prefix;
        private final String _oldUri;
        private final String _newUri;

        Decl(NamespaceBinding binding, String prefix, String oldUri, String newUri) {
            this._binding = binding;
            this._prefix = prefix;
            this._oldUri = oldUri;
            this._newUri = newUri;
        }

        NamespaceBinding getBinding() {
            return this._binding;
        }

        String getPrefix() {
            return this._prefix;
        }

        String getOldUri() {
            return this._oldUri;
        }

        String getNewUri() {
            return this._newUri;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ElementBinding {
        private SaxIntern.Entry _name;
        private ArrayList<Decl> _declList;

        ElementBinding() {
        }

        public void setName(SaxIntern.Entry name) {
            this._name = name;
        }

        public SaxIntern.Entry getName() {
            return this._name;
        }

        public void addOldBinding(NamespaceBinding binding, String prefix, String oldUri, String newUri) {
            if (this._declList == null) {
                this._declList = new ArrayList();
            }
            this._declList.add(new Decl(binding, prefix, oldUri, newUri));
        }

        public ArrayList<Decl> getOldBindingList() {
            return this._declList;
        }

        public void clear() {
            this._declList = null;
        }
    }
}

