/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.xml.stream.NamespaceBinding;
import com.caucho.xml.stream.NamespaceReaderContext;
import javax.xml.namespace.QName;

public class StaxIntern {
    private static final int SIZE = 203;
    private final Entry[] _entries = new Entry[203];
    private final NamespaceReaderContext _namespaceContext;

    StaxIntern(NamespaceReaderContext namespaceContext) {
        this._namespaceContext = namespaceContext;
    }

    Entry add(char[] buffer, int offset, int length, int colon, boolean isAttribute) {
        int hash = 0;
        for (int i = length - 1; i >= 0; --i) {
            hash = 37 * hash + buffer[offset + i];
        }
        int bucket = (hash & Integer.MAX_VALUE) % 203;
        Entry entry = this._entries[bucket];
        while (entry != null) {
            if (entry.match(buffer, offset, length, isAttribute)) {
                return entry;
            }
            entry = entry._next;
        }
        this._entries[bucket] = entry = new Entry(this._entries[bucket], buffer, offset, length, colon, isAttribute);
        return entry;
    }

    final class Entry {
        final Entry _next;
        final char[] _buf;
        final boolean _isAttribute;
        final String _prefix;
        final String _localName;
        NamespaceBinding _namespace;
        int _version;
        QName _qName;

        Entry(Entry next, char[] buf, int offset, int length, int colon, boolean isAttribute) {
            this._next = next;
            this._buf = new char[length];
            System.arraycopy(buf, offset, this._buf, 0, length);
            this._isAttribute = isAttribute;
            if (colon > 0) {
                this._prefix = new String(buf, 0, colon);
                this._localName = new String(buf, colon + 1, length - colon - 1);
            } else {
                this._prefix = "";
                this._localName = new String(buf, 0, length);
            }
            this._namespace = this._isAttribute ? StaxIntern.this._namespaceContext.getAttributeNamespace(this._prefix) : StaxIntern.this._namespaceContext.getElementNamespace(this._prefix);
            this.fillQName();
        }

        public final boolean match(char[] buf, int offset, int length, boolean isAttribute) {
            if (length != this._buf.length || this._isAttribute != isAttribute) {
                return false;
            }
            char[] entryBuf = this._buf;
            --length;
            while (length >= 0) {
                if (entryBuf[length] != buf[offset + length]) {
                    return false;
                }
                --length;
            }
            return true;
        }

        String getLocalName() {
            return this._localName;
        }

        String getPrefix() {
            return this._prefix;
        }

        QName getQName() {
            if (this._version != this._namespace.getVersion()) {
                this.fillQName();
            }
            return this._qName;
        }

        private void fillQName() {
            this._version = this._namespace.getVersion();
            String prefix = this._prefix;
            if (prefix == null) {
                prefix = "";
            }
            this._qName = new QName(this._namespace.getUri(), this._localName, prefix);
        }
    }
}

