/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class FilteredStreamReader
implements XMLStreamReader {
    private XMLStreamReader _reader;
    private StreamFilter _filter;

    public FilteredStreamReader(XMLStreamReader reader, StreamFilter filter) throws XMLStreamException {
        this._reader = reader;
        this._filter = filter;
    }

    public int nextTag() throws XMLStreamException {
        while (this._reader.hasNext()) {
            this._reader.nextTag();
            if (!this._filter.accept(this._reader)) continue;
            break;
        }
        return this._reader.getEventType();
    }

    public int next() throws XMLStreamException {
        while (this._reader.hasNext()) {
            this._reader.next();
            if (!this._filter.accept(this._reader)) continue;
            break;
        }
        return this._reader.getEventType();
    }

    public boolean hasNext() throws XMLStreamException {
        do {
            if (this._reader.getEventType() == 8) {
                return false;
            }
            if (this._filter.accept(this._reader)) {
                return true;
            }
            this._reader.next();
        } while (this._reader.hasNext());
        return false;
    }

    public void close() throws XMLStreamException {
        this._reader.close();
    }

    public int getAttributeCount() {
        return this._reader.getAttributeCount();
    }

    public String getAttributeLocalName(int index) {
        return this._reader.getAttributeLocalName(index);
    }

    public QName getAttributeName(int index) {
        return this._reader.getAttributeName(index);
    }

    public String getAttributeNamespace(int index) {
        return this._reader.getAttributeNamespace(index);
    }

    public String getAttributePrefix(int index) {
        return this._reader.getAttributePrefix(index);
    }

    public String getAttributeType(int index) {
        return this._reader.getAttributeType(index);
    }

    public String getAttributeValue(int index) {
        return this._reader.getAttributeValue(index);
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        return this._reader.getAttributeValue(namespaceURI, localName);
    }

    public String getCharacterEncodingScheme() {
        return this._reader.getCharacterEncodingScheme();
    }

    public String getElementText() throws XMLStreamException {
        return this._reader.getElementText();
    }

    public String getEncoding() {
        return this._reader.getEncoding();
    }

    public int getEventType() {
        return this._reader.getEventType();
    }

    public String getLocalName() {
        return this._reader.getLocalName();
    }

    public Location getLocation() {
        return this._reader.getLocation();
    }

    public QName getName() {
        return this._reader.getName();
    }

    public NamespaceContext getNamespaceContext() {
        return this._reader.getNamespaceContext();
    }

    public int getNamespaceCount() {
        return this._reader.getNamespaceCount();
    }

    public String getNamespacePrefix(int index) {
        return this._reader.getNamespacePrefix(index);
    }

    public String getNamespaceURI() {
        return this._reader.getNamespaceURI();
    }

    public String getNamespaceURI(int index) {
        return this._reader.getNamespaceURI(index);
    }

    public String getNamespaceURI(String prefix) {
        return this._reader.getNamespaceURI(prefix);
    }

    public String getPIData() {
        return this._reader.getPIData();
    }

    public String getPITarget() {
        return this._reader.getPITarget();
    }

    public String getPrefix() {
        return this._reader.getPrefix();
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return this._reader.getProperty(name);
    }

    public String getText() {
        return this._reader.getText();
    }

    public char[] getTextCharacters() {
        return this._reader.getTextCharacters();
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return this._reader.getTextCharacters(sourceStart, target, targetStart, length);
    }

    public int getTextLength() {
        return this._reader.getTextLength();
    }

    public int getTextStart() {
        return this._reader.getTextStart();
    }

    public String getVersion() {
        return this._reader.getVersion();
    }

    public boolean hasName() {
        return this._reader.hasName();
    }

    public boolean hasText() {
        return this._reader.hasText();
    }

    public boolean isAttributeSpecified(int index) {
        return this._reader.isAttributeSpecified(index);
    }

    public boolean isCharacters() {
        return this._reader.isCharacters();
    }

    public boolean isEndElement() {
        return this._reader.isEndElement();
    }

    public boolean isStandalone() {
        return this._reader.isStandalone();
    }

    public boolean isStartElement() {
        return this._reader.isStartElement();
    }

    public boolean isWhiteSpace() {
        return this._reader.isWhiteSpace();
    }

    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        this._reader.require(type, namespaceURI, localName);
    }

    public boolean standaloneSet() {
        return this._reader.standaloneSet();
    }
}

