/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.xml.Entities;
import com.caucho.xml.HtmlEntities;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;

class OtherEntities
extends HtmlEntities {
    private static Entities _html40;
    private static Entities _html32;

    static Entities create(double version) {
        if (version == 0.0 || version >= 4.0) {
            if (_html40 == null) {
                _html40 = new OtherEntities(4.0);
            }
            return _html40;
        }
        if (_html32 == null) {
            _html32 = new OtherEntities(3.2);
        }
        return _html32;
    }

    protected OtherEntities(double version) {
        super(version);
    }

    void printText(XmlPrinter os, char[] text, int offset, int length, boolean attr) throws IOException {
        for (int i = 0; i < length; ++i) {
            char ch = text[i + offset];
            if (ch == '&') {
                if (i + 1 < length && text[i + 1] == '{') {
                    os.print('&');
                    continue;
                }
                if (attr) {
                    os.print(this._attrLatin1[ch]);
                    continue;
                }
                os.print(this._latin1[ch]);
                continue;
            }
            if (ch == '\"') {
                if (attr) {
                    os.print("&quot;");
                    continue;
                }
                os.print('\"');
                continue;
            }
            if (ch == '<') {
                if (attr) {
                    os.print('<');
                    continue;
                }
                os.print("&lt;");
                continue;
            }
            if (ch == '>') {
                if (attr) {
                    os.print('>');
                    continue;
                }
                os.print("&gt;");
                continue;
            }
            if (ch < '\u00a1') {
                os.print(this._latin1[ch]);
                continue;
            }
            try {
                os.print(ch);
                continue;
            }
            catch (IOException e) {
                char[] value = this.getSparseEntity(ch);
                if (value != null) {
                    os.print(value);
                    continue;
                }
                os.print("&#");
                os.print((int)ch);
                os.print(";");
            }
        }
    }
}

