/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ZipScanner {
    private static Logger _log;
    private char[] _cbuf = new char[256];
    private int _nameLen;
    private Path _path;
    private ReadStream _is;
    private ReadStream _fileIs;
    private boolean _isValid;
    private int _entries;
    private int _offset;
    private int _index;
    private int _localFileOffset;
    private String _name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipScanner(Path path) {
        try {
            ReadStream is;
            block7: {
                this._path = path;
                int length = (int)path.getLength();
                is = path.openRead();
                try {
                    is.skip(length - 22 - 7);
                    if (is.read() != 80) {
                        is.skip(6L);
                        if (is.read() != 80) {
                            Object var5_5 = null;
                            is.close();
                            return;
                        }
                    }
                    if (is.read() == 75 && is.read() == 5 && is.read() == 6) {
                        this._isValid = true;
                    }
                    if (!this._isValid) break block7;
                    is.skip(6L);
                    this._entries = is.read() + (is.read() << 8);
                    is.skip(4L);
                    this._offset = ZipScanner.readInt(is);
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    is.close();
                    throw throwable;
                }
            }
            Object var5_6 = null;
            is.close();
            {
            }
        }
        catch (Exception e) {
            ZipScanner.log().log(Level.FINER, e.toString(), e);
        }
    }

    public final boolean open() throws IOException {
        if (!this._isValid) {
            return false;
        }
        this._is = this._path.openRead();
        this._is.skip(this._offset);
        this._index = 0;
        return true;
    }

    public final boolean next() throws IOException {
        if (this._entries <= this._index) {
            return false;
        }
        ++this._index;
        ReadStream is = this._is;
        if (is.readInt() != 1347092738) {
            throw new IOException("illegal zip format");
        }
        is.skip(16L);
        int compressedSize = ZipScanner.readInt(is);
        int uncompressedSize = ZipScanner.readInt(is);
        int nameLen = is.read() + (is.read() << 8);
        int extraLen = is.read() + (is.read() << 8);
        int commentLen = is.read() + (is.read() << 8);
        is.skip(8L);
        this._localFileOffset = ZipScanner.readInt(is);
        this._nameLen = nameLen;
        if (this._cbuf.length < nameLen) {
            this._cbuf = new char[nameLen];
        }
        char[] cbuf = this._cbuf;
        int k = is.readUTF8ByByteLength(cbuf, 0, nameLen);
        for (int i = k - 1; i >= 0; --i) {
            char ch = cbuf[i];
            if (ch != '\\') continue;
            cbuf[i] = 47;
        }
        this._name = null;
        if (extraLen + commentLen > 0) {
            is.skip(extraLen + commentLen);
        }
        return true;
    }

    public final String getName() {
        if (this._name == null) {
            this._name = new String(this._cbuf, 0, this._nameLen);
        }
        return this._name;
    }

    public final char[] getNameBuffer() {
        return this._cbuf;
    }

    public final int getNameLength() {
        return this._nameLen;
    }

    private static int readInt(InputStream is) throws IOException {
        int value = (is.read() & 0xFF) + ((is.read() & 0xFF) << 8) + ((is.read() & 0xFF) << 16) + ((is.read() & 0xFF) << 24);
        return value;
    }

    public void close() {
        ReadStream is = this._is;
        this._is = null;
        ReadStream fileIs = this._fileIs;
        this._fileIs = null;
        if (is != null) {
            try {
                ((InputStream)is).close();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (fileIs != null) {
            try {
                ((InputStream)fileIs).close();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(ZipScanner.class.getName());
        }
        return _log;
    }
}

