/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.Reader;

public class ReaderStream
extends StreamImpl {
    private static final L10N L = new L10N(ReaderStream.class);
    private Reader _reader;
    private int _peek = -1;

    ReaderStream(Reader reader) {
        this._reader = reader;
    }

    public static ReadStream open(Reader reader) {
        ReaderStream ss = new ReaderStream(reader);
        return new ReadStream(ss);
    }

    public Path getPath() {
        throw new UnsupportedOperationException();
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        int i = offset;
        int end = i + length;
        while (i < end) {
            int ch;
            if (this._peek >= 0) {
                ch = this._peek;
                this._peek = -1;
            } else {
                ch = this._reader.read();
            }
            if (ch < 0) break;
            if (ch < 128) {
                buf[i++] = (byte)ch;
                continue;
            }
            if (ch < 2048) {
                if (i + 1 >= end) {
                    if (i == offset) {
                        throw new IllegalStateException(L.l("buffer is not large enough to accept UTF-8 encoding.  length={0}, 2-character utf-8", length));
                    }
                    this._peek = ch;
                    return end - offset;
                }
                buf[i++] = (byte)(0xC0 | ch >> 6);
                buf[i++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            if (ch >= 32768) continue;
            if (i + 2 >= end) {
                if (i == offset) {
                    throw new IllegalStateException(L.l("buffer is not large enough to accept UTF-8 encoding.  length={0}, 3-character utf-8", length));
                }
                this._peek = ch;
                return i - offset;
            }
            buf[i++] = (byte)(0xE0 | ch >> 12);
            buf[i++] = (byte)(0x80 | ch >> 6 & 0x3F);
            buf[i++] = (byte)(0x80 | ch >> 6 & 0x3F);
        }
        return i - offset;
    }

    public int getAvailable() throws IOException {
        throw new UnsupportedOperationException();
    }
}

