/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.inject.Module;
import com.caucho.util.CurrentTime;
import com.caucho.util.JniTroubleshoot;
import com.caucho.util.JniUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.InetAddressUtil;
import com.caucho.vfs.JniServerSocketImpl;
import com.caucho.vfs.JniStream;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public final class JniSocketImpl
extends QSocket {
    private static final L10N L;
    private static final Logger log;
    private static final JniTroubleshoot _jniTroubleshoot;
    private JniServerSocketImpl _ss;
    private final long _socketFd;
    private int _nativeFd;
    private JniStream _stream;
    private final byte[] _localAddrBuffer = new byte[16];
    private final char[] _localAddrCharBuffer = new char[256];
    private int _localAddrLength;
    private String _localName;
    private InetAddress _localAddr;
    private int _localPort;
    private final byte[] _remoteAddrBuffer = new byte[16];
    private final char[] _remoteAddrCharBuffer = new char[256];
    private int _remoteAddrLength;
    private String _remoteName;
    private InetAddress _remoteAddr;
    private int _remotePort;
    private boolean _isSecure;
    private Object _readLock = new Object();
    private Object _writeLock = new Object();
    private boolean _isNativeFlushRequired;
    private long _socketTimeout;
    private long _requestExpireTime;
    private final AtomicBoolean _isClosed = new AtomicBoolean();

    public JniSocketImpl() {
        this._socketFd = this.nativeAllocate();
    }

    public static boolean isEnabled() {
        return _jniTroubleshoot.isEnabled();
    }

    public static String getInitMessage() {
        if (!_jniTroubleshoot.isEnabled()) {
            return _jniTroubleshoot.getMessage();
        }
        return null;
    }

    public static JniSocketImpl connect(String host, int port) throws IOException {
        JniSocketImpl socket = new JniSocketImpl();
        if (socket.connectImpl(host, port)) {
            return socket;
        }
        socket.close();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connectImpl(String host, int port) throws IOException {
        this._socketTimeout = 10000L;
        this._nativeFd = -1;
        this._isClosed.set(false);
        Object object = this._writeLock;
        synchronized (object) {
            return this.nativeConnect(this._socketFd, host, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean accept(JniServerSocketImpl ss, long serverSocketFd, long socketTimeout) {
        this._ss = ss;
        this._localName = null;
        this._localAddr = null;
        this._localAddrLength = 0;
        this._remoteName = null;
        this._remoteAddr = null;
        this._remoteAddrLength = 0;
        this._socketTimeout = socketTimeout;
        this._requestExpireTime = 0L;
        this._nativeFd = -1;
        this._isSecure = false;
        this._isClosed.set(false);
        Object object = this._writeLock;
        synchronized (object) {
            return this.nativeAccept(serverSocketFd, this._socketFd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int acceptInitialRead(byte[] buffer, int offset, int length) {
        Object object = this._readLock;
        synchronized (object) {
            int result = this.nativeAcceptInit(this._socketFd, this._localAddrBuffer, this._remoteAddrBuffer, buffer, offset, length);
            return result;
        }
    }

    public long getFd() {
        return this._socketFd;
    }

    public int getNativeFd() {
        if (this._nativeFd < 0) {
            this._nativeFd = this.getNativeFd(this._socketFd);
        }
        return this._nativeFd;
    }

    public int getLocalPort() {
        return this._localPort;
    }

    public String getRemoteHost() {
        if (this._remoteName == null) {
            byte[] remoteAddrBuffer = this._remoteAddrBuffer;
            char[] remoteAddrCharBuffer = this._remoteAddrCharBuffer;
            if (this._remoteAddrLength <= 0) {
                this._remoteAddrLength = InetAddressUtil.createIpAddress(remoteAddrBuffer, remoteAddrCharBuffer);
            }
            this._remoteName = new String(remoteAddrCharBuffer, 0, this._remoteAddrLength);
        }
        return this._remoteName;
    }

    public InetAddress getRemoteAddress() {
        if (this._remoteAddr == null) {
            try {
                this._remoteAddr = InetAddress.getByName(this.getRemoteHost());
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._remoteAddr;
    }

    public int getRemoteAddress(byte[] buffer, int offset, int length) {
        int len = this._remoteAddrLength;
        if (len <= 0) {
            len = this._remoteAddrLength = InetAddressUtil.createIpAddress(this._remoteAddrBuffer, this._remoteAddrCharBuffer);
        }
        char[] charBuffer = this._remoteAddrCharBuffer;
        for (int i = len - 1; i >= 0; --i) {
            buffer[offset + i] = (byte)charBuffer[i];
        }
        return len;
    }

    public byte[] getRemoteIP() {
        return this._remoteAddrBuffer;
    }

    public int getRemotePort() {
        return this._remotePort;
    }

    public String getLocalHost() {
        if (this._localName == null) {
            byte[] localAddrBuffer = this._localAddrBuffer;
            char[] localAddrCharBuffer = this._localAddrCharBuffer;
            if (this._localAddrLength <= 0) {
                this._localAddrLength = InetAddressUtil.createIpAddress(localAddrBuffer, localAddrCharBuffer);
            }
            this._localName = new String(localAddrCharBuffer, 0, this._localAddrLength);
        }
        return this._localName;
    }

    public InetAddress getLocalAddress() {
        if (this._localAddr == null) {
            try {
                this._localAddr = InetAddress.getByName(this.getLocalHost());
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._localAddr;
    }

    public int getLocalAddress(byte[] buffer, int offset, int length) {
        System.arraycopy(this._localAddrBuffer, 0, buffer, offset, this._localAddrLength);
        return this._localAddrLength;
    }

    public void setSecure(boolean isSecure) {
        this._isSecure = isSecure;
    }

    public final boolean isSecure() {
        return this._isSecure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCipherSuite() {
        JniSocketImpl jniSocketImpl = this;
        synchronized (jniSocketImpl) {
            return this.getCipher(this._socketFd);
        }
    }

    public int getCipherBits() {
        return this.getCipherBits(this._socketFd);
    }

    public X509Certificate getClientCertificate() throws CertificateException {
        TempBuffer tb = TempBuffer.allocate();
        byte[] buffer = tb.getBuffer();
        int len = this.getClientCertificate(this._socketFd, buffer, 0, buffer.length);
        X509Certificate cert = null;
        if (len > 0 && len < buffer.length) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream is = new ByteArrayInputStream(buffer, 0, len);
                cert = (X509Certificate)cf.generateCertificate(is);
                ((InputStream)is).close();
            }
            catch (IOException e) {
                return null;
            }
        }
        TempBuffer.free(tb);
        tb = null;
        return cert;
    }

    public void setRequestExpireTime(long expireTime) {
        this._requestExpireTime = expireTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEof() {
        Object object = this._readLock;
        synchronized (object) {
            return this.nativeIsEof(this._socketFd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer, int offset, int length, long timeout) throws IOException {
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        if (buffer.length < length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long requestExpireTime = this._requestExpireTime;
        if (requestExpireTime > 0L && requestExpireTime < CurrentTime.getCurrentTime()) {
            this.close();
            throw new ClientDisconnectException(L.l("{0}: request-timeout read", (Object)this.getRemoteAddress()));
        }
        int result = 0;
        Object object = this._readLock;
        synchronized (object) {
            long now = CurrentTime.getCurrentTimeActual();
            long gap = 20L;
            long expires = timeout >= 0L ? timeout + now - gap : this._socketTimeout + now - gap;
            do {
                result = this.readNative(this._socketFd, buffer, offset, length, timeout);
                now = CurrentTime.getCurrentTimeActual();
                timeout = expires - now;
            } while (result == -4 && timeout > 0L);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
        int result;
        long requestExpireTime = this._requestExpireTime;
        if (requestExpireTime > 0L && requestExpireTime < CurrentTime.getCurrentTime()) {
            this.close();
            throw new ClientDisconnectException(L.l("{0}: request-timeout write exp={0}s", (Object)this.getRemoteAddress(), (Object)(CurrentTime.getCurrentTime() - requestExpireTime)));
        }
        Object object = this._writeLock;
        synchronized (object) {
            long now = CurrentTime.getCurrentTimeActual();
            long expires = this._socketTimeout + now;
            while ((result = JniSocketImpl.writeNative(this._socketFd, buffer, offset, length)) == -4 && CurrentTime.getCurrentTimeActual() < expires) {
            }
        }
        if (isEnd) {
            this.close();
        }
        return result;
    }

    public boolean isMmapEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeMmap(long mmapAddress, long[] mmapBlocks, long mmapOffset, long mmapLength) throws IOException {
        int result;
        long requestExpireTime = this._requestExpireTime;
        if (requestExpireTime > 0L && requestExpireTime < CurrentTime.getCurrentTime()) {
            this.close();
            throw new ClientDisconnectException(L.l("{0}: request-timeout write", (Object)this.getRemoteAddress()));
        }
        Object object = this._writeLock;
        synchronized (object) {
            long now = CurrentTime.getCurrentTimeActual();
            long expires = this._socketTimeout + now;
            this._isNativeFlushRequired = true;
            while ((result = this.writeMmapNative(this._socketFd, mmapAddress, mmapBlocks, mmapOffset, mmapLength)) == -4 && CurrentTime.getCurrentTimeActual() < expires) {
            }
        }
        return result;
    }

    public boolean isSendfileEnabled() {
        return JniServerSocketImpl.isSendfileEnabledStatic() && this._ss.isSendfileEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeSendfile(byte[] buffer, int offset, int length, byte[] fileName, int nameLength, long fileLength) throws IOException {
        int result;
        long requestExpireTime = this._requestExpireTime;
        if (requestExpireTime > 0L && requestExpireTime < CurrentTime.getCurrentTime()) {
            this.close();
            throw new ClientDisconnectException(L.l("{0}: request-timeout sendfile", (Object)this.getRemoteAddress()));
        }
        Object object = this._writeLock;
        synchronized (object) {
            long now = CurrentTime.getCurrentTimeActual();
            long expires = this._socketTimeout + now;
            this._isNativeFlushRequired = false;
            while ((result = this.writeSendfileNative(this._socketFd, buffer, offset, length, fileName, nameLength, fileLength)) == -4 && CurrentTime.getCurrentTimeActual() < expires) {
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush() throws IOException {
        if (!this._isNativeFlushRequired) {
            return 0;
        }
        Object object = this._writeLock;
        synchronized (object) {
            this._isNativeFlushRequired = false;
            return this.flushNative(this._socketFd);
        }
    }

    public StreamImpl getStream() throws IOException {
        if (this._stream == null) {
            this._stream = new JniStream(this);
        }
        this._stream.init();
        return this._stream;
    }

    public long getTotalReadBytes() {
        return this._stream == null ? 0L : this._stream.getTotalReadBytes();
    }

    public long getTotalWriteBytes() {
        return this._stream == null ? 0L : this._stream.getTotalWriteBytes();
    }

    public boolean isClosed() {
        return this._isClosed.get();
    }

    public void forceShutdown() {
        this.nativeCloseFd(this._socketFd);
    }

    public void close() throws IOException {
        if (this._isClosed.getAndSet(true)) {
            return;
        }
        this._ss = null;
        if (this._stream != null) {
            this._stream.close();
        }
        this._nativeFd = -1;
        this.nativeClose(this._socketFd);
    }

    protected void finalize() throws Throwable {
        long fd = this._socketFd;
        try {
            super.finalize();
            this.nativeClose(fd);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.nativeFree(fd);
    }

    native int getNativeFd(long var1);

    native boolean nativeIsEof(long var1);

    private native boolean nativeAccept(long var1, long var3);

    private native int nativeAcceptInit(long var1, byte[] var3, byte[] var4, byte[] var5, int var6, int var7);

    private native boolean nativeConnect(long var1, String var3, int var4);

    native String getCipher(long var1);

    native int getCipherBits(long var1);

    native int getClientCertificate(long var1, byte[] var3, int var4, int var5);

    native int readNative(long var1, byte[] var3, int var4, int var5, long var6) throws IOException;

    private static native int writeNative(long var0, byte[] var2, int var3, int var4) throws IOException;

    native int writeNative2(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws IOException;

    native int writeMmapNative(long var1, long var3, long[] var5, long var6, long var8) throws IOException;

    native int writeSendfileNative(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, long var8) throws IOException;

    native int flushNative(long var1) throws IOException;

    private native void nativeCloseFd(long var1);

    private native void nativeClose(long var1);

    native long nativeAllocate();

    native void nativeFree(long var1);

    public String toString() {
        return "JniSocketImpl$" + System.identityHashCode(this) + "[" + Long.toHexString(this._socketFd) + ",fd=" + this.getNativeFd(this._socketFd) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        JniTroubleshoot jniTroubleshoot;
        block4: {
            L = new L10N(JniSocketImpl.class);
            log = Logger.getLogger(JniSocketImpl.class.getName());
            jniTroubleshoot = null;
            JniUtil.acquire();
            try {
                try {
                    System.loadLibrary("resin_os");
                    jniTroubleshoot = new JniTroubleshoot(JniSocketImpl.class, "resin_os");
                }
                catch (Throwable e) {
                    jniTroubleshoot = new JniTroubleshoot(JniSocketImpl.class, "resin_os", e);
                    Object var3_2 = null;
                    JniUtil.release();
                    break block4;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                JniUtil.release();
                throw throwable;
            }
            JniUtil.release();
        }
        _jniTroubleshoot = jniTroubleshoot;
        new ClientDisconnectException();
    }
}

