/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.JniTroubleshoot;
import com.caucho.util.JniUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.JniSocketImpl;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QSocket;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;

public class JniServerSocketImpl
extends QServerSocket {
    private static final L10N L;
    private static final JniTroubleshoot _jniTroubleshoot;
    private static final boolean _isSendfileEnabled;
    private static final boolean _isCorkEnabled;
    private long _fd;
    private String _id;
    private String _host;
    private long _socketTimeout = 120000L;
    private boolean _isSSL;

    private JniServerSocketImpl(String host, int port) throws IOException {
        this._fd = JniServerSocketImpl.bindPort(host, port);
        this._id = host + ":" + port;
        this._host = host;
        if (this._fd == 0L) {
            throw new IOException(L.l("Socket bind failed for {0}:{1} while running as {2}.  Check for other processes listening to the port and check for permissions (root on unix).", (Object)host, (Object)port, (Object)System.getProperty("user.name")));
        }
    }

    private JniServerSocketImpl(int fd, int port, boolean isOpen) throws IOException {
        this._fd = JniServerSocketImpl.nativeOpenPort(fd, port);
        this._id = "fd=" + fd + ",port=" + port;
        if (this._fd == 0L) {
            throw new BindException(L.l("Socket bind failed for port {0} fd={1} opened by watchdog.  Check that the watchdog and Resin permissions are properly configured.", port, fd));
        }
    }

    public static boolean isEnabled() {
        return _jniTroubleshoot.isEnabled();
    }

    public static String getInitMessage() {
        if (!_jniTroubleshoot.isEnabled()) {
            return _jniTroubleshoot.getMessage();
        }
        return null;
    }

    public static boolean isSendfileEnabledStatic() {
        return _isSendfileEnabled;
    }

    public void setSSL(boolean isSSL) {
        this._isSSL = isSSL;
    }

    public boolean isSendfileEnabled() {
        return JniServerSocketImpl.isSendfileEnabledStatic() && !this._isSSL;
    }

    public static boolean isTcpCorkEnabled() {
        return _isCorkEnabled;
    }

    public long getFd() {
        return this._fd;
    }

    public boolean isJni() {
        return true;
    }

    public boolean isJniValid() {
        return JniServerSocketImpl.isEnabled();
    }

    public boolean setSaveOnExec() {
        return this.nativeSetSaveOnExec(this._fd);
    }

    public int getSystemFD() {
        return this.nativeGetSystemFD(this._fd);
    }

    public void listen(int backlog) {
        this.nativeListen(this._fd, backlog);
    }

    public static QServerSocket create(String host, int port) throws IOException {
        _jniTroubleshoot.checkIsValid();
        return new JniServerSocketImpl(host, port);
    }

    public static QServerSocket open(int fd, int port) throws IOException {
        _jniTroubleshoot.checkIsValid();
        return new JniServerSocketImpl(fd, port, true);
    }

    public void setConnectionSocketTimeout(int ms) {
        this._socketTimeout = ms;
        this.nativeSetConnectionSocketTimeout(this._fd, ms);
    }

    public void setTcpNoDelay(boolean isEnable) {
        this.nativeSetTcpNoDelay(this._fd, isEnable);
    }

    public boolean isTcpNoDelay() {
        return this.nativeIsTcpNoDelay(this._fd);
    }

    public void setTcpKeepalive(boolean isEnable) {
        this.nativeSetTcpKeepalive(this._fd, isEnable);
    }

    public boolean isTcpKeepalive() {
        return this.nativeIsTcpKeepalive(this._fd);
    }

    public void setTcpCork(boolean isEnable) {
        if (_isCorkEnabled) {
            this.nativeSetTcpCork(this._fd, isEnable);
        }
    }

    public boolean isTcpCork() {
        return this.nativeIsTcpCork(this._fd);
    }

    public boolean accept(QSocket socket) throws IOException {
        JniSocketImpl jniSocket = (JniSocketImpl)socket;
        if (this._fd == 0L) {
            throw new IOException("accept from closed socket");
        }
        return jniSocket.accept(this, this._fd, this._socketTimeout);
    }

    public QSocket createSocket() throws IOException {
        return new JniSocketImpl();
    }

    public InetAddress getLocalAddress() {
        try {
            if (this._host != null) {
                return InetAddress.getByName(this._host);
            }
            return InetAddress.getLocalHost();
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getLocalPort() {
        return this.getLocalPort(this._fd);
    }

    public boolean isClosed() {
        return this._fd == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        long fd;
        JniServerSocketImpl jniServerSocketImpl = this;
        synchronized (jniServerSocketImpl) {
            fd = this._fd;
            this._fd = 0L;
        }
        if (fd != 0L) {
            this.closeNative(fd);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }

    public void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    static native long bindPort(String var0, int var1);

    static native long nativeOpenPort(int var0, int var1);

    native void nativeSetConnectionSocketTimeout(long var1, int var3);

    native void nativeSetTcpNoDelay(long var1, boolean var3);

    native boolean nativeIsTcpNoDelay(long var1);

    native void nativeSetTcpKeepalive(long var1, boolean var3);

    native boolean nativeIsTcpKeepalive(long var1);

    native void nativeSetTcpCork(long var1, boolean var3);

    native boolean nativeIsTcpCork(long var1);

    native void nativeListen(long var1, int var3);

    private native int getLocalPort(long var1);

    private native int nativeGetSystemFD(long var1);

    private native boolean nativeSetSaveOnExec(long var1);

    private static native boolean nativeIsSendfileEnabled();

    private static native boolean nativeIsCorkEnabled();

    native int closeNative(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        boolean isCorkEnabled;
        boolean isSendfileEnabled;
        JniTroubleshoot jniTroubleshoot;
        block4: {
            L = new L10N(JniServerSocketImpl.class);
            jniTroubleshoot = null;
            isSendfileEnabled = false;
            isCorkEnabled = false;
            JniUtil.acquire();
            try {
                try {
                    System.loadLibrary("resin_os");
                    jniTroubleshoot = new JniTroubleshoot(JniServerSocketImpl.class, "resin_os");
                    isSendfileEnabled = JniServerSocketImpl.nativeIsSendfileEnabled();
                    isCorkEnabled = JniServerSocketImpl.nativeIsCorkEnabled();
                }
                catch (Throwable e) {
                    jniTroubleshoot = new JniTroubleshoot(JniServerSocketImpl.class, "resin_os", e);
                    Object var5_4 = null;
                    JniUtil.release();
                    break block4;
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                JniUtil.release();
                throw throwable;
            }
            JniUtil.release();
        }
        _jniTroubleshoot = jniTroubleshoot;
        _isSendfileEnabled = isSendfileEnabled;
        _isCorkEnabled = isCorkEnabled;
    }
}

