/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.L10N;
import java.util.concurrent.atomic.AtomicReferenceArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RingValueArray<T> {
    private static final L10N L = new L10N(RingValueArray.class);
    private final AtomicReferenceArray<T> _ring;
    private final int _length;
    private final int _mask;

    RingValueArray(int length) {
        this._length = length;
        if (Integer.bitCount(this._length) != 1) {
            throw new IllegalArgumentException(L.l("Invalid ring capacity {0}", (Object)Long.toHexString(this._length)));
        }
        this._ring = new AtomicReferenceArray(this._length);
        this._mask = this._length - 1;
    }

    public final int getLength() {
        return this._length;
    }

    public final T get(long ptr) {
        return this._ring.get(this.getIndex(ptr));
    }

    public final void set(long ptr, T value) {
        this._ring.set(this.getIndex(ptr), value);
    }

    public final T takeAndClear(long ptr) {
        T value;
        int index = this.getIndex(ptr);
        AtomicReferenceArray<T> ring = this._ring;
        while ((value = ring.getAndSet(index, null)) == null) {
        }
        return value;
    }

    public final T pollAndClear(long ptr) {
        AtomicReferenceArray<T> ring = this._ring;
        int index = this.getIndex(ptr);
        T value = ring.get(index);
        if (value != null && ring.compareAndSet(index, value, null)) {
            return value;
        }
        return null;
    }

    public final int getIndex(long ptr) {
        return (int)(ptr & (long)this._mask);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._ring.getClass().getSimpleName() + "," + this.getLength() + "]";
    }
}

