/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.HashKey;
import java.security.MessageDigest;
import java.util.concurrent.atomic.AtomicReference;

public class HashKeyManager {
    public static final int SIZE = 32;
    public static final String HASH_ALGORITHM = "SHA-256";
    public static final HashKey NULL = new HashKey(new byte[32]);
    private static final HashKeyManager _manager = new HashKeyManager();
    private final AtomicReference<MessageDigest> _digestRef = new AtomicReference();

    public static HashKey generateHash(String key) {
        return _manager.generateHashImpl(key);
    }

    public static HashKey generateHash(HashKey priorHash, String key) {
        return _manager.generateHashImpl(priorHash, key);
    }

    private HashKey generateHashImpl(String key) {
        MessageDigest digest = this.getDigest();
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            char ch = key.charAt(i);
            digest.update((byte)ch);
            digest.update((byte)(ch >> 8));
        }
        HashKey hashKey = new HashKey(digest.digest());
        this._digestRef.set(digest);
        return hashKey;
    }

    private HashKey generateHashImpl(HashKey priorHash, String key) {
        MessageDigest digest = this.getDigest();
        digest.update(priorHash.getHash());
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            char ch = key.charAt(i);
            digest.update((byte)ch);
            digest.update((byte)(ch >> 8));
        }
        HashKey hashKey = new HashKey(digest.digest());
        this._digestRef.set(digest);
        return hashKey;
    }

    private MessageDigest getDigest() {
        MessageDigest digest = this._digestRef.getAndSet(null);
        if (digest != null) {
            digest.reset();
        } else {
            try {
                digest = MessageDigest.getInstance(HASH_ALGORITHM);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return digest;
    }
}

