/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicFuture<V>
implements Future<V> {
    private volatile V _value;
    private volatile boolean _isDone;
    private volatile RuntimeException _exn;
    private volatile Thread _thread;

    @Override
    public boolean isDone() {
        return this._isDone;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Thread thread = Thread.currentThread();
        try {
            this._thread = thread;
            long expires = System.currentTimeMillis() + unit.toMillis(timeout);
            do {
                if (this._isDone) {
                    if (this._exn != null) {
                        throw this._exn;
                    }
                    V v = this._value;
                    Object var9_6 = null;
                    this._thread = null;
                    return v;
                }
                Thread.interrupted();
                LockSupport.parkUntil(expires);
            } while (System.currentTimeMillis() < expires);
            throw new TimeoutException(this.toString() + ": " + timeout + " " + (Object)((Object)unit));
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this._thread = null;
            throw throwable;
        }
    }

    public void complete(V value) {
        this._value = value;
        this._isDone = true;
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    public void complete(RuntimeException exn) {
        this._exn = exn;
        this._isDone = true;
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    @Override
    public boolean cancel(boolean value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean isCancelled() {
        return false;
    }
}

