/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.tools.profiler.ConnectionWrapper;
import com.caucho.tools.profiler.ProfilerPoint;
import com.caucho.tools.profiler.XAResourceWrapper;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public final class XAConnectionWrapper
implements XAConnection {
    private final XAConnection _connection;
    private final ProfilerPoint _profilerPoint;
    private XAResource _xaResource;

    public XAConnectionWrapper(ProfilerPoint profilerPoint, XAConnection connection) {
        this._profilerPoint = profilerPoint;
        this._connection = connection;
    }

    private ConnectionWrapper wrap(Connection connection) {
        return new ConnectionWrapper(this._profilerPoint, connection);
    }

    private XAResourceWrapper wrap(XAResource xaResource) {
        return new XAResourceWrapper(this._profilerPoint, xaResource);
    }

    public XAResource getXAResource() throws SQLException {
        return this.wrap(this._connection.getXAResource());
    }

    public Connection getConnection() throws SQLException {
        return this.wrap(this._connection.getConnection());
    }

    public void close() throws SQLException {
        this._connection.close();
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this._connection.addConnectionEventListener(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this._connection.removeConnectionEventListener(listener);
    }

    public String toString() {
        return "XAConnectionWrapper[" + this._profilerPoint.getName() + "]";
    }

    public void addStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

