/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.tools.profiler.Profiler;
import com.caucho.tools.profiler.ProfilerPoint;
import com.caucho.tools.profiler.ResultSetWrapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatementWrapper
implements Statement {
    private final ProfilerPoint _parentProfilerPoint;
    private final Statement _statement;
    private ProfilerPoint _profilerPoint;

    public StatementWrapper(ProfilerPoint profilerPoint, Statement statement) {
        this._parentProfilerPoint = profilerPoint;
        this._profilerPoint = profilerPoint;
        this._statement = statement;
    }

    private void setSql(String sql) {
        this._profilerPoint = this._parentProfilerPoint.addProfilerPoint(sql);
    }

    private ResultSet wrap(ResultSet resultSet) {
        return new ResultSetWrapper(this._profilerPoint, resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            ResultSet resultSet = this.wrap(this._statement.executeQuery(sql));
            Object var5_4 = null;
            profiler.finish();
            return resultSet;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.executeUpdate(sql);
            Object var5_4 = null;
            profiler.finish();
            return n;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.close();
            Object var3_2 = null;
            profiler.finish();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxFieldSize() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getMaxFieldSize();
            Object var4_3 = null;
            profiler.finish();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.setMaxFieldSize(max);
            Object var4_3 = null;
            profiler.finish();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxRows() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getMaxRows();
            Object var4_3 = null;
            profiler.finish();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxRows(int max) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.setMaxRows(max);
            Object var4_3 = null;
            profiler.finish();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.setEscapeProcessing(enable);
            Object var4_3 = null;
            profiler.finish();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueryTimeout() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getQueryTimeout();
            Object var4_3 = null;
            profiler.finish();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.setQueryTimeout(seconds);
            Object var4_3 = null;
            profiler.finish();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.cancel();
            Object var3_2 = null;
            profiler.finish();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            SQLWarning sQLWarning = this._statement.getWarnings();
            Object var4_3 = null;
            profiler.finish();
            return sQLWarning;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.clearWarnings();
            Object var3_2 = null;
            profiler.finish();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorName(String name) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.setCursorName(name);
            Object var4_3 = null;
            profiler.finish();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._statement.execute(sql);
            Object var5_4 = null;
            profiler.finish();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            profiler.finish();
            throw throwable;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.wrap(this._statement.getResultSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateCount() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getUpdateCount();
            Object var4_3 = null;
            profiler.finish();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._statement.getMoreResults();
            Object var4_3 = null;
            profiler.finish();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int direction) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.setFetchDirection(direction);
            Object var4_3 = null;
            profiler.finish();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchDirection() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getFetchDirection();
            Object var4_3 = null;
            profiler.finish();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int rows) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.setFetchSize(rows);
            Object var4_3 = null;
            profiler.finish();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getFetchSize();
            Object var4_3 = null;
            profiler.finish();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultSetConcurrency() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getResultSetConcurrency();
            Object var4_3 = null;
            profiler.finish();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultSetType() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getResultSetType();
            Object var4_3 = null;
            profiler.finish();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String sql) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.addBatch(sql);
            Object var4_3 = null;
            profiler.finish();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._statement.clearBatch();
            Object var3_2 = null;
            profiler.finish();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int[] nArray = this._statement.executeBatch();
            Object var4_3 = null;
            profiler.finish();
            return nArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Connection connection = this._statement.getConnection();
            Object var4_3 = null;
            profiler.finish();
            return connection;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int current) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._statement.getMoreResults(current);
            Object var5_4 = null;
            profiler.finish();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            profiler.finish();
            throw throwable;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.wrap(this._statement.getGeneratedKeys());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.executeUpdate(sql, autoGeneratedKeys);
            Object var6_5 = null;
            profiler.finish();
            return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.executeUpdate(sql, columnIndexes);
            Object var6_5 = null;
            profiler.finish();
            return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.executeUpdate(sql, columnNames);
            Object var6_5 = null;
            profiler.finish();
            return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._statement.execute(sql, autoGeneratedKeys);
            Object var6_5 = null;
            profiler.finish();
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._statement.execute(sql, columnIndexes);
            Object var6_5 = null;
            profiler.finish();
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.setSql(sql);
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._statement.execute(sql, columnNames);
            Object var6_5 = null;
            profiler.finish();
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            profiler.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultSetHoldability() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._statement.getResultSetHoldability();
            Object var4_3 = null;
            profiler.finish();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            profiler.finish();
            throw throwable;
        }
    }

    public String toString() {
        return "StatementWrapper[" + this._profilerPoint.getName() + "]";
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

