/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.tools.profiler.ConnectionWrapper;
import com.caucho.tools.profiler.ProfilerPoint;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public final class PooledConnectionWrapper
implements PooledConnection {
    private final PooledConnection _connection;
    private final ProfilerPoint _profilerPoint;

    public PooledConnectionWrapper(ProfilerPoint profilerPoint, PooledConnection connection) {
        this._profilerPoint = profilerPoint;
        this._connection = connection;
    }

    private Connection wrap(Connection connection) {
        return new ConnectionWrapper(this._profilerPoint, connection);
    }

    public Connection getConnection() throws SQLException {
        return this.wrap(this._connection.getConnection());
    }

    public void close() throws SQLException {
        this._connection.close();
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this._connection.addConnectionEventListener(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this._connection.removeConnectionEventListener(listener);
    }

    public String toString() {
        return "PooledConnectionWrapper[" + this._profilerPoint.getName() + "]";
    }

    public void addStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

