/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.tools.profiler.PooledConnectionWrapper;
import com.caucho.tools.profiler.ProfilerPoint;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class ConnectionPoolDataSourceWrapper
implements ConnectionPoolDataSource {
    private final ProfilerPoint _profilerPoint;
    private final ConnectionPoolDataSource _dataSource;

    public ConnectionPoolDataSourceWrapper(ProfilerPoint profilerPoint, ConnectionPoolDataSource dataSource) {
        this._profilerPoint = profilerPoint;
        this._dataSource = dataSource;
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return this.wrap(this._dataSource.getPooledConnection());
    }

    private PooledConnection wrap(PooledConnection pooledConnection) {
        return new PooledConnectionWrapper(this._profilerPoint, pooledConnection);
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return this.wrap(this._dataSource.getPooledConnection(user, password));
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this._dataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this._dataSource.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this._dataSource.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this._dataSource.getLoginTimeout();
    }

    public Logger getParentLogger() {
        return null;
    }

    public String toString() {
        return "ConnectionPoolDataSourceWrapper[" + this._profilerPoint.getName() + "]";
    }
}

