/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.sql.spy.SpyConnection;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.SQLExceptionWrapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpyStatement
implements Statement {
    protected static final Logger log = Logger.getLogger(SpyStatement.class.getName());
    protected static final L10N L = new L10N(SpyConnection.class);
    protected String _id;
    protected SpyConnection _conn;
    protected Statement _stmt;

    SpyStatement(String id, SpyConnection conn, Statement stmt) {
        this._id = id;
        this._conn = conn;
        this._stmt = stmt;
    }

    protected long start() {
        return CurrentTime.getExactTime();
    }

    protected void log(long start, String msg) {
        long delta = CurrentTime.getExactTime() - start;
        log.fine("[" + delta + "ms] " + this.getId() + ":" + msg);
    }

    public String getId() {
        if (this._id == null) {
            this._id = this._conn.createStatementId();
        }
        return this._id;
    }

    public Statement getStatement() {
        return this._stmt;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        long start = this.start();
        try {
            this._stmt.addBatch(sql);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "addBatch(" + sql + ")");
            }
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-addBatch(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void cancel() throws SQLException {
        long start = this.start();
        try {
            this._stmt.cancel();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "cancel()");
            }
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-cancel(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        long start = this.start();
        try {
            this._stmt.clearBatch();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "clearBatch()");
            }
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-clearBatch(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        long start = this.start();
        try {
            this._stmt.clearWarnings();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "clearWarnings()");
            }
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-clearWarnings(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void close() throws SQLException {
        long start = this.start();
        try {
            Statement stmt = this._stmt;
            this._stmt = null;
            if (stmt != null) {
                stmt.close();
            }
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "stmt-close()");
            }
        }
        catch (RuntimeException e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-close(" + e + ")");
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-close(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        long start = this.start();
        try {
            ResultSet rs = this._stmt.executeQuery(sql);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "executeQuery(" + sql + ")");
            }
            return rs;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-executeQuery(" + sql + ") -> " + e);
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        long start = this.start();
        try {
            int count = this._stmt.executeUpdate(sql);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "executeUpdate(" + sql + ") -> " + count);
            }
            return count;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-executeUpdate(" + sql + ") -> " + e);
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        long start = this.start();
        try {
            boolean hasResult = this._stmt.execute(sql);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "execute(" + sql + ") -> " + hasResult);
            }
            return hasResult;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-execute(" + sql + ") -> " + e);
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        long start = this.start();
        try {
            int[] result = this._stmt.executeBatch();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "executeBatch()");
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-executeBatch(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        long start = this.start();
        try {
            ResultSet result = this._stmt.getResultSet();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getResultSet() -> " + (result != null ? result.getClass().getName() : ""));
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-getResultSet(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        long start = this.start();
        try {
            int updateCount = this._stmt.getUpdateCount();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getUpdateCount() -> " + updateCount);
            }
            return updateCount;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-getUpdateCount(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        long start = this.start();
        try {
            int result = this._stmt.getFetchDirection();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getFetchDirection() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-getFetchDirection(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        long start = this.start();
        try {
            int result = this._stmt.getFetchSize();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getFetchSize() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-getFetchSize(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        long start = this.start();
        try {
            int result = this._stmt.getMaxFieldSize();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getMaxFieldSize() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-getMaxFieldSize(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        long start = this.start();
        try {
            int result = this._stmt.getMaxRows();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getMaxRows() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-getMaxRows(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        long start = this.start();
        try {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "setMaxRows(" + max + ")");
            }
            this._stmt.setMaxRows(max);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-setMaxRows(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        long start = this.start();
        try {
            boolean result = this._stmt.getMoreResults();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getMoreResults() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-getMoreResults(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        long start = this.start();
        try {
            int result = this._stmt.getQueryTimeout();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getQueryTimeout() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-getQueryTimeout(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        long start = this.start();
        try {
            int result = this._stmt.getResultSetConcurrency();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getResultSetConcurrency() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, ":exn-getResultSetConcurrency(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        long start = this.start();
        try {
            int result = this._stmt.getResultSetType();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getResultSetType() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-getResultSetType(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        long start = this.start();
        try {
            SQLWarning result = this._stmt.getWarnings();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getWarnings() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-getWarnings(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        long start = this.start();
        try {
            this._stmt.setCursorName(name);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "setCursorName(" + name + ")");
            }
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-setCursorName(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        long start = this.start();
        try {
            this._stmt.setEscapeProcessing(enable);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "setEscapeProcessing(" + enable + ")");
            }
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setEscapeProcessing(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        long start = this.start();
        try {
            this._stmt.setFetchDirection(direction);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "setFetchDirection(" + direction + ")");
            }
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-setFetchDirection(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        long start = this.start();
        try {
            this._stmt.setFetchSize(rows);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "setFetchSize(" + rows + ")");
            }
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-setFetchSize(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        long start = this.start();
        try {
            this._stmt.setMaxFieldSize(max);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "setMaxFieldSize(" + max + ")");
            }
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-setMaxFieldSize(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        long start = this.start();
        try {
            this._stmt.setQueryTimeout(seconds);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "setQueryTimeout(" + seconds + ")");
            }
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-setQueryTimeout(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public boolean getMoreResults(int count) throws SQLException {
        long start = this.start();
        try {
            boolean moreResults = this._stmt.getMoreResults(count);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getMoreResults(" + count + ") -> " + moreResults);
            }
            return moreResults;
        }
        catch (SQLException e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getMoreResults(" + e + ")");
            }
            throw e;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        long start = this.start();
        try {
            ResultSet generatedKeys = this._stmt.getGeneratedKeys();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getGeneratedKeys() -> " + generatedKeys);
            }
            return generatedKeys;
        }
        catch (SQLException e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getGeneratedKeys(" + e + ")");
            }
            throw e;
        }
    }

    @Override
    public int executeUpdate(String query, int resultType) throws SQLException {
        long start = this.start();
        try {
            int rowsUpdated = this._stmt.executeUpdate(query, resultType);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "executeUpdate(" + query + ", resultType=" + resultType + ") -> " + rowsUpdated);
            }
            return rowsUpdated;
        }
        catch (SQLException e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-executeUpdate(" + e + ")");
            }
            throw e;
        }
    }

    @Override
    public int executeUpdate(String query, int[] columns) throws SQLException {
        long start = this.start();
        try {
            int rowsUpdated = this._stmt.executeUpdate(query, columns);
            if (log.isLoggable(Level.FINE)) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int column : columns) {
                    list.add(column);
                }
                this.log(start, "executeUpdate(" + query + ", columns=" + list + ") -> " + rowsUpdated);
            }
            return rowsUpdated;
        }
        catch (SQLException e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-executeUpdate(" + e + ")");
            }
            throw e;
        }
    }

    @Override
    public int executeUpdate(String query, String[] columns) throws SQLException {
        long start = this.start();
        try {
            int rowsUpdated = this._stmt.executeUpdate(query, columns);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "executeUpdate(" + query + ", columns=" + Arrays.asList(columns) + ") -> " + rowsUpdated);
            }
            return rowsUpdated;
        }
        catch (SQLException e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-executeUpdate(" + e + ")");
            }
            throw e;
        }
    }

    @Override
    public boolean execute(String query, int resultType) throws SQLException {
        long start = this.start();
        try {
            boolean isResultSet = this._stmt.execute(query, resultType);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "execute(" + query + ", resultType=" + resultType + ") -> " + isResultSet);
            }
            return isResultSet;
        }
        catch (SQLException e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-execute(" + e + ")");
            }
            throw e;
        }
    }

    @Override
    public boolean execute(String query, int[] columns) throws SQLException {
        long start = this.start();
        try {
            boolean isResultSet = this._stmt.execute(query, columns);
            if (log.isLoggable(Level.FINE)) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int column : columns) {
                    list.add(column);
                }
                this.log(start, "execute(" + query + ", columns=" + list + ")");
            }
            return isResultSet;
        }
        catch (SQLException e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-execute(" + e + ")");
            }
            throw e;
        }
    }

    @Override
    public boolean execute(String query, String[] columns) throws SQLException {
        long start = this.start();
        try {
            boolean isResultSet = this._stmt.execute(query, columns);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "execute(" + query + ", columns=" + Arrays.asList(columns) + ") -> " + isResultSet);
            }
            return isResultSet;
        }
        catch (SQLException e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-execute(" + e + ")");
            }
            throw e;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        long start = this.start();
        try {
            int holdability = this._stmt.getResultSetHoldability();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "getResultSetHoldability() -> " + holdability);
            }
            return holdability;
        }
        catch (SQLException e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-getResultSetHoldability(" + e + ")");
            }
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        long start = this.start();
        try {
            boolean closed = this._stmt.isClosed();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "isClosed() -> " + closed);
            }
            return closed;
        }
        catch (SQLException e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "isClosed(" + e + ")");
            }
            throw e;
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        long start = this.start();
        try {
            this._stmt.setPoolable(poolable);
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "setPoolable(" + poolable + ")");
            }
        }
        catch (SQLException e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-setPoolable(" + e + ")");
            }
            throw e;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        long start = this.start();
        try {
            boolean isPoolable = this._stmt.isPoolable();
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "isPoolable() -> " + isPoolable);
            }
            return isPoolable;
        }
        catch (SQLException e) {
            if (log.isLoggable(Level.FINE)) {
                this.log(start, "exn-isPoolable(" + e + ")");
            }
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            T t = this._stmt.unwrap(iface);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":unwrap(" + iface + ") -> " + t);
            }
            return t;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-unwrap(" + e + ")");
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            boolean isWrapper = this._stmt.isWrapperFor(iface);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":isWrapperFor(" + iface + ") -> " + isWrapper);
            }
            return isWrapper;
        }
        catch (SQLException e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-isWrapperFor(" + e + ")");
            }
            throw e;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

