/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.Credential;
import com.caucho.sql.ManagedFactoryImpl;
import com.caucho.util.L10N;
import com.caucho.util.SQLExceptionWrapper;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDataSource
implements DataSource {
    private static final L10N L = new L10N(UserDataSource.class);
    protected static final Logger log = Logger.getLogger(UserDataSource.class.getName());
    private final ManagedFactoryImpl _managedFactory;
    private final ConnectionManager _connManager;

    UserDataSource(ManagedFactoryImpl factory, ConnectionManager cm) {
        this._managedFactory = factory;
        this._connManager = cm;
    }

    public String getURL() {
        return this._managedFactory.getURL();
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return (Connection)this._connManager.allocateConnection(this._managedFactory, null);
        }
        catch (ResourceException e) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof SQLException)) continue;
                throw (SQLException)cause;
            }
            throw new SQLExceptionWrapper(e);
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        try {
            Credential credential = null;
            if (username != null || password != null) {
                credential = new Credential(username, password);
            }
            return (Connection)this._connManager.allocateConnection(this._managedFactory, credential);
        }
        catch (ResourceException e) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof SQLException)) continue;
                throw (SQLException)cause;
            }
            throw new SQLExceptionWrapper(e);
        }
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public void setLoginTimeout(int seconds) {
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    boolean isClosed() {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new SQLException(L.l("Can't unwrap `{0}' to `{1}'", (Object)this, (Object)iface));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    public String toString() {
        return "UserDataSource[" + this._managedFactory + "]";
    }
}

