/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets.ssi;

import com.caucho.servlets.ssi.ConcatExpr;
import com.caucho.servlets.ssi.EqExpr;
import com.caucho.servlets.ssi.GeExpr;
import com.caucho.servlets.ssi.GtExpr;
import com.caucho.servlets.ssi.LeExpr;
import com.caucho.servlets.ssi.LtExpr;
import com.caucho.servlets.ssi.SSIExpr;
import com.caucho.servlets.ssi.StringExpr;
import com.caucho.servlets.ssi.VarExpr;
import com.caucho.vfs.Path;

public class ExprParser {
    private String _expr;
    private int _index;
    private Path _path;
    private StringBuilder _sb = new StringBuilder();

    private ExprParser(String expr, Path path) {
        this._expr = expr;
        this._path = path;
    }

    public static SSIExpr parseString(String expr, Path path) {
        return new ExprParser(expr, path).parseString();
    }

    public static SSIExpr parseConcat(String expr, Path path) {
        return new ExprParser(expr, path).parseConcat();
    }

    private SSIExpr parseString() {
        SSIExpr expr = this.parseTerm();
        return expr;
    }

    private SSIExpr parseTerm() {
        int ch;
        SSIExpr expr = null;
        while ((ch = this.read()) >= 0) {
            if (ch == 36) {
                if (this._sb.length() > 0) {
                    expr = ConcatExpr.create(expr, new StringExpr(this._sb.toString()));
                }
                this._sb.setLength(0);
                SSIExpr var = this.parseVar();
                expr = ConcatExpr.create(expr, var);
                continue;
            }
            if (ch == 92) {
                ch = this.read();
                if (ch == 36) {
                    this._sb.append((char)ch);
                    continue;
                }
                if (ch == 92) {
                    this._sb.append((char)ch);
                    continue;
                }
                this._sb.append('\\');
                this.unread();
                continue;
            }
            if (ch == 61) {
                if (this._sb.length() > 0) {
                    expr = ConcatExpr.create(expr, new StringExpr(this._sb.toString()));
                }
                this._sb.setLength(0);
                SSIExpr right = this.parseTerm();
                return new EqExpr(expr, this.parseTerm());
            }
            if (ch == 60) {
                if (this._sb.length() > 0) {
                    expr = ConcatExpr.create(expr, new StringExpr(this._sb.toString()));
                }
                this._sb.setLength(0);
                ch = this.read();
                if (ch == 61) {
                    return new LeExpr(expr, this.parseTerm());
                }
                this.unread();
                return new LtExpr(expr, this.parseTerm());
            }
            if (ch == 62) {
                if (this._sb.length() > 0) {
                    expr = ConcatExpr.create(expr, new StringExpr(this._sb.toString()));
                }
                this._sb.setLength(0);
                ch = this.read();
                if (ch == 61) {
                    return new GeExpr(expr, this.parseTerm());
                }
                this.unread();
                return new GtExpr(expr, this.parseTerm());
            }
            this._sb.append((char)ch);
        }
        if (this._sb.length() > 0) {
            expr = ConcatExpr.create(expr, new StringExpr(this._sb.toString()));
        }
        return expr;
    }

    private SSIExpr parseConcat() {
        int ch;
        SSIExpr expr = null;
        while ((ch = this.read()) >= 0) {
            if (ch == 36) {
                if (this._sb.length() > 0) {
                    expr = ConcatExpr.create(expr, new StringExpr(this._sb.toString()));
                }
                this._sb.setLength(0);
                SSIExpr var = this.parseVar();
                expr = ConcatExpr.create(expr, var);
                continue;
            }
            if (ch == 92) {
                ch = this.read();
                if (ch == 36) {
                    this._sb.append((char)ch);
                    continue;
                }
                if (ch == 92) {
                    this._sb.append((char)ch);
                    continue;
                }
                this._sb.append('\\');
                this.unread();
                continue;
            }
            this._sb.append((char)ch);
        }
        if (this._sb.length() > 0) {
            expr = ConcatExpr.create(expr, new StringExpr(this._sb.toString()));
        }
        return expr;
    }

    private SSIExpr parseVar() {
        int ch = this.read();
        if (ch == 123) {
            ch = this.read();
            while (ch >= 0 && ch != 125) {
                this._sb.append((char)ch);
                ch = this.read();
            }
        } else {
            while (97 <= ch && ch <= 122 || 65 <= ch && ch <= 90 || 48 <= ch && ch <= 57 || ch == 95) {
                this._sb.append((char)ch);
                ch = this.read();
            }
            this.unread();
        }
        VarExpr var = new VarExpr(this._sb.toString(), this._path);
        this._sb.setLength(0);
        return var;
    }

    private int read() {
        if (this._index < this._expr.length()) {
            return this._expr.charAt(this._index++);
        }
        ++this._index;
        return -1;
    }

    private void unread() {
        --this._index;
    }
}

