/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.cloud.loadbalance.LoadBalanceBackend;
import com.caucho.cloud.loadbalance.LoadBalanceBuilder;
import com.caucho.cloud.loadbalance.LoadBalanceService;
import com.caucho.cloud.loadbalance.LoadBalanceStrategy;
import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.network.proxy.HttpProxyClient;
import com.caucho.network.proxy.HttpProxyClientFactory;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpProxyServlet
extends GenericServlet {
    private static final Logger log = Logger.getLogger(HttpProxyServlet.class.getName());
    private static final L10N L = new L10N(HttpProxyServlet.class);
    private List<LoadBalanceBackend> _backends = new ArrayList<LoadBalanceBackend>();
    private LoadBalanceBuilder _loadBalanceBuilder;
    private HttpProxyClient _proxyClient;

    public HttpProxyServlet() {
        LoadBalanceService loadBalanceService = LoadBalanceService.getCurrent();
        if (loadBalanceService == null) {
            throw new IllegalStateException(L.l("'{0}' requires an active {1}", (Object)this, (Object)LoadBalanceService.class.getSimpleName()));
        }
        this._loadBalanceBuilder = loadBalanceService.createBuilder();
    }

    public void addHost(String host) {
        this.addAddress(host);
    }

    public void addAddress(String address) {
        this.addBackend(new LoadBalanceBackend(address));
    }

    public void addBackend(LoadBalanceBackend backend) {
        this._backends.add(backend);
    }

    public void setConnectTimeout(Period connectTimeout) {
        this._loadBalanceBuilder.setConnectTimeout(connectTimeout.getPeriod());
    }

    public void setConnectionMin(int connectionMin) {
        this._loadBalanceBuilder.setConnectionMin(connectionMin);
    }

    public void setSocketTimeout(Period socketTimeout) {
        this._loadBalanceBuilder.setSocketTimeout(socketTimeout.getPeriod());
    }

    public void setIdleTime(Period idleTime) {
        this._loadBalanceBuilder.setIdleTime(idleTime.getPeriod());
    }

    public void setRecoverTime(Period recoverTime) {
        this._loadBalanceBuilder.setRecoverTime(recoverTime.getPeriod());
    }

    public void setWarmupTime(Period warmupTime) {
        this._loadBalanceBuilder.setWarmupTime(warmupTime.getPeriod());
    }

    public void setStrategy(String strategy) {
        if ("round-robin".equalsIgnoreCase(strategy)) {
            this._loadBalanceBuilder.setStrategy(LoadBalanceStrategy.ROUND_ROBIN);
        } else if ("least-connection".equalsIgnoreCase(strategy)) {
            this._loadBalanceBuilder.setStrategy(LoadBalanceStrategy.ADAPTIVE);
        } else if ("adaptive".equalsIgnoreCase(strategy)) {
            this._loadBalanceBuilder.setStrategy(LoadBalanceStrategy.ADAPTIVE);
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown load-balance strategy.  'round-robin' and 'least-connection' are the known values.", (Object)strategy));
        }
    }

    public LoadBalanceBuilder getLoadBalanceBuilder() {
        return this._loadBalanceBuilder;
    }

    public void init() throws ServletException {
        if (this._proxyClient != null) {
            return;
        }
        for (LoadBalanceBackend backend : this._backends) {
            this._loadBalanceBuilder.addBackend(backend);
        }
        HttpProxyClientFactory factory = new HttpProxyClientFactory();
        this._proxyClient = factory.create(this._loadBalanceBuilder.create());
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        this._proxyClient.handleRequest(req, res);
    }
}

