/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webbeans;

import com.caucho.config.scope.AbstractScopeContext;
import com.caucho.config.scope.ContextContainer;
import com.caucho.config.scope.ScopeRemoveListener;
import com.caucho.server.dispatch.ServletInvocation;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationContext
extends AbstractScopeContext
implements Conversation,
Serializable {
    private static final Logger log = Logger.getLogger(ConversationContext.class.getName());
    private static final L10N L = new L10N(ConversationContext.class);
    private static final String SESSION_CONVERSATION = "caucho.session.conversation";
    private static final String SESSION_CONVERSATION_ID = "caucho.session.conversation.id";
    private static final String REQUEST_CONVERSATION = "caucho.request.conversation";
    private static final long DEFAULT_TIMEOUT = 120000L;

    @Override
    public boolean isActive() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            return true;
        }
        return this.isSessionScope();
    }

    @Override
    public boolean isTransient() {
        Scope scope = this.getConversationScope();
        return scope == null || scope._extendedId == null;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return ConversationScoped.class;
    }

    @Override
    protected ContextContainer getContextContainer() {
        Scope scope = this.getConversationScope();
        if (scope != null) {
            return scope._transientConversation;
        }
        return null;
    }

    @Override
    protected ContextContainer createContextContainer() {
        Scope scope = this.createConversationScope();
        if (scope._transientConversation == null) {
            scope._transientConversation = new ContextContainer();
        }
        return scope._transientConversation;
    }

    @Override
    public void begin() {
        StringBuilder sb = new StringBuilder();
        sb.append(RandomUtil.getRandomLong() & Long.MAX_VALUE);
        this.begin(sb.toString());
    }

    @Override
    public void begin(String name) {
        Scope scope = this.createConversationScope(name);
        if (scope._extendedId != null) {
            throw new IllegalStateException(L.l("Conversation begin() must only be called when a long-running conversation does not exist."));
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && name != null) {
            facesContext.getViewRoot().getAttributes().put("caucho.cid", name);
        }
        scope._extendedId = name;
        scope.put(name, scope._transientConversation);
    }

    @Override
    public void end() {
        Scope scope = this.getConversationScope();
        if (scope == null) {
            return;
        }
        String id = scope._extendedId;
        scope._extendedId = null;
        if (id == null) {
            throw new IllegalStateException(L.l("Conversation end() must only be called when a long-running conversation exists."));
        }
        scope.remove(id);
    }

    @Override
    public String getId() {
        Scope scope = this.getConversationScope();
        if (scope != null) {
            return scope._extendedId;
        }
        return null;
    }

    @Override
    public long getTimeout() {
        Scope scope = this.createConversationScope();
        return scope.getTimeout();
    }

    @Override
    public void setTimeout(long timeout) {
        try {
            Scope scope = this.createConversationScope();
            scope.setTimeout(timeout);
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void destroy() {
        Scope scope = this.getConversationScope();
        if (scope == null) {
            return;
        }
        this.destroy(scope, true);
    }

    private void destroy(Scope scope, boolean isClearId) {
        if (scope == null) {
            return;
        }
        ContextContainer context = scope._transientConversation;
        if (isClearId) {
            scope._transientConversation = null;
        }
        if (scope._extendedId == null) {
            context.close();
        }
        if (isClearId) {
            scope._extendedId = null;
        }
    }

    private Scope getConversationScope() {
        Scope scope = this.getJsfScope();
        if (scope != null) {
            return scope;
        }
        return this.getSessionScope();
    }

    private Scope createConversationScope() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            return this.createJsfScope();
        }
        return this.createSessionScope();
    }

    private Scope createConversationScope(String name) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            return this.createJsfScope(name);
        }
        return this.createSessionScope(name);
    }

    private Scope getJsfScope() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return null;
        }
        return this.getJsfScope(facesContext, null, false);
    }

    private Scope createJsfScope() {
        return this.createJsfScope(null);
    }

    private Scope createJsfScope(String name) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw new IllegalStateException(L.l("@ConversationScoped is not available because JSF is not active"));
        }
        return this.getJsfScope(facesContext, name, true);
    }

    private Scope getJsfScope(FacesContext facesContext, String name, boolean isCreate) {
        Map requestMap;
        String cid;
        ExternalContext extContext = facesContext.getExternalContext();
        Map sessionMap = extContext.getSessionMap();
        Scope scope = (Scope)sessionMap.get(SESSION_CONVERSATION);
        if (scope == null) {
            if (!isCreate) {
                return null;
            }
            scope = new Scope();
            try {
                sessionMap.put(SESSION_CONVERSATION, scope);
            }
            catch (Exception e) {
                this.getSessionScope();
            }
        }
        if ((cid = (String)(requestMap = extContext.getRequestParameterMap()).get("cid")) == null) {
            cid = (String)facesContext.getViewRoot().getAttributes().get("caucho.cid");
        }
        if (scope._transientConversation == null) {
            if (cid != null) {
                scope._extendedId = cid;
                scope._transientConversation = scope.get(cid);
                if (scope._transientConversation == null) {
                    throw new IllegalStateException(L.l("Conversation cid={0} is an unknown conversation", (Object)cid));
                }
            } else if (name != null) {
                scope._extendedId = name;
                scope._transientConversation = scope.get(name);
            } else if (scope._extendedId != null) {
                scope._transientConversation = scope.get(scope._extendedId);
                if (scope._transientConversation == null) {
                    throw new IllegalStateException(L.l("Conversation id={0} is an unknown conversation", (Object)scope._extendedId));
                }
            }
        }
        return scope;
    }

    private boolean isSessionScope() {
        ServletRequest request = ServletInvocation.getContextRequest();
        if (request != null) {
            HttpSession session = ((HttpServletRequest)request).getSession();
            return session != null;
        }
        return false;
    }

    private Scope getSessionScope() {
        ServletRequest request = ServletInvocation.getContextRequest();
        if (request == null) {
            return null;
        }
        HttpSession session = ((HttpServletRequest)request).getSession();
        if (session == null) {
            return null;
        }
        Scope scope = (Scope)session.getAttribute(SESSION_CONVERSATION);
        if (scope == null) {
            return null;
        }
        if (scope._transientConversation == null) {
            scope._transientConversation = scope.get(scope._extendedId);
        }
        return scope;
    }

    private Scope createSessionScope() {
        ServletRequest request = ServletInvocation.getContextRequest();
        if (request == null) {
            return null;
        }
        HttpSession session = ((HttpServletRequest)request).getSession();
        if (session == null) {
            return null;
        }
        Scope scope = (Scope)session.getAttribute(SESSION_CONVERSATION);
        if (scope == null) {
            scope = new Scope();
            session.setAttribute(SESSION_CONVERSATION, scope);
        }
        request.setAttribute(REQUEST_CONVERSATION, new RequestListener(scope));
        return scope;
    }

    private Scope createSessionScope(String name) {
        Scope scope = this.createSessionScope();
        if (scope == null) {
            return null;
        }
        if (scope._transientConversation == null) {
            if (name != null) {
                scope._transientConversation = scope.get(name);
            } else if (scope._extendedId != null) {
                scope._transientConversation = scope.get(scope._extendedId);
                if (scope._transientConversation == null) {
                    throw new IllegalStateException(L.l("Conversation id={0} is an unknown conversation", (Object)scope._extendedId));
                }
            } else {
                scope._transientConversation = new ContextContainer();
            }
        }
        return scope;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    class RequestListener
    implements ScopeRemoveListener {
        private Scope _scope;

        RequestListener(Scope scope) {
            this._scope = scope;
        }

        public void removeEvent(Object scope, String name) {
            ConversationContext.this.destroy(this._scope, false);
        }
    }

    static class Scope
    implements Serializable,
    HttpSessionBindingListener {
        ContextContainer _transientConversation;
        String _extendedId;
        String _lastId;
        private Map<String, ContextContainer> _conversationMap;
        private long _timeout = 120000L;

        Scope() {
        }

        public long getTimeout() {
            return this._timeout;
        }

        public void setTimeout(long timeout) {
            this._timeout = timeout;
        }

        public ContextContainer get(String id) {
            if (this._conversationMap != null) {
                return this._conversationMap.get(id);
            }
            return null;
        }

        public ContextContainer remove(String id) {
            if (this._conversationMap != null) {
                return this._conversationMap.remove(id);
            }
            return null;
        }

        public void put(String id, ContextContainer container) {
            if (this._conversationMap == null) {
                this._conversationMap = new HashMap<String, ContextContainer>();
            }
            this._conversationMap.put(id, container);
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            if (this._conversationMap == null) {
                return;
            }
            for (ContextContainer conversation : this._conversationMap.values()) {
                conversation.close();
            }
            this._conversationMap = null;
        }
    }
}

