/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.webapp.CauchoFilterChain;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.transaction.UserTransactionImpl;
import com.caucho.transaction.UserTransactionProxy;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResumeFilterChain
implements CauchoFilterChain {
    private static final Logger log = Logger.getLogger(ResumeFilterChain.class.getName());
    private FilterChain _next;
    private WebApp _webApp;
    private TransactionManagerImpl _tm;
    private UserTransactionProxy _utm;
    private ErrorPageManager _errorPageManager;
    private HashMap<String, String> _securityRoleMap;

    public ResumeFilterChain(FilterChain next, WebApp webApp) {
        this._next = next;
        this._webApp = webApp;
        this._errorPageManager = webApp.getErrorPageManager();
        try {
            this._tm = TransactionManagerImpl.getInstance();
            this._utm = UserTransactionProxy.getInstance();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void setSecurityRoleMap(HashMap<String, String> map) {
        this._securityRoleMap = map;
    }

    @Override
    public FilterChain getNext() {
        return this._next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        block16: {
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            WebApp webApp = this._webApp;
            UserTransactionImpl ut = null;
            ut = this._utm.getUserTransaction();
            thread.setContextClassLoader(webApp.getClassLoader());
            if (!webApp.enterWebApp() && webApp.getConfigException() == null) {
                throw new IllegalStateException("Cannot enter web-app");
            }
            this._next.doFilter(request, response);
            Object var9_7 = null;
            webApp.exitWebApp();
            if (request instanceof HttpServletRequestImpl) {
                ((HttpServletRequestImpl)request).finishInvocation();
            }
            try {
                if (ut != null) {
                    ut.abortTransaction();
                }
            }
            catch (Throwable e2) {
                log.log(Level.WARNING, e2.toString(), e2);
            }
            thread.setContextClassLoader(oldLoader);
            {
                break block16;
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                    Object var9_8 = null;
                    webApp.exitWebApp();
                    if (request instanceof HttpServletRequestImpl) {
                        ((HttpServletRequestImpl)request).finishInvocation();
                    }
                    try {
                        if (ut != null) {
                            ut.abortTransaction();
                        }
                    }
                    catch (Throwable e2) {
                        log.log(Level.WARNING, e2.toString(), e2);
                    }
                    thread.setContextClassLoader(oldLoader);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                webApp.exitWebApp();
                if (request instanceof HttpServletRequestImpl) {
                    ((HttpServletRequestImpl)request).finishInvocation();
                }
                try {
                    if (ut != null) {
                        ut.abortTransaction();
                    }
                }
                catch (Throwable e2) {
                    log.log(Level.WARNING, e2.toString(), e2);
                }
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._webApp.getURL() + ", next=" + this._next + "]";
    }
}

