/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.spdy;

import com.caucho.network.listen.AbstractProtocolConnection;
import com.caucho.network.listen.SocketLink;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.server.spdy.SpdyServerProtocol;
import com.caucho.server.spdy.SpdyStream;
import com.caucho.server.spdy.SpdyWriteActor;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

class SpdyConnection
extends AbstractProtocolConnection {
    private static final Logger log = Logger.getLogger(SpdyConnection.class.getName());
    private static final L10N L = new L10N(SpdyConnection.class);
    public static final int CONTROL_FLAG = 128;
    public static final int SYN_STREAM = 1;
    public static final int SYN_REPLY = 2;
    public static final int RST_STREAM = 3;
    public static final int SETTINGS = 4;
    public static final int PING = 6;
    public static final int GOAWAY = 7;
    public static final int HEADERS = 8;
    public static final int WINDOW_UPDATE = 9;
    private SpdyServerProtocol _spdy;
    private TcpSocketLink _link;
    private SpdyWriteActor _actor;
    private int _lastServerId;

    SpdyConnection(SpdyServerProtocol spdy, SocketLink link) {
        this._spdy = spdy;
        this._link = (TcpSocketLink)link;
        this._actor = new SpdyWriteActor(this);
    }

    WriteStream getWriteStream() {
        return this._link.getWriteStream();
    }

    public boolean isWaitForRead() {
        return true;
    }

    public boolean handleRequest() throws IOException {
        ReadStream rs = this._link.getReadStream();
        int ch = rs.read();
        if (ch < 0) {
            return false;
        }
        if ((ch & 0x80) != 0) {
            return this.parseControlFrame(rs, ch);
        }
        return this.parseDataFrame(rs, ch);
    }

    private boolean parseControlFrame(ReadStream rs, int ch) throws IOException {
        int version = ((ch & 0x7F) << 8) + rs.read();
        if (version != 3) {
            throw new IOException(L.l("Unknown SPDY version {0}\n", version));
        }
        int type = this.readShort(rs);
        int flags = rs.read();
        int length = this.readInt24(rs);
        long pos = rs.getPosition();
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " type=0x" + Integer.toHexString(type) + " flags=0x" + Integer.toHexString(flags) + " len=" + length + " version=" + version);
        }
        boolean isValid = false;
        switch (type) {
            case 1: {
                isValid = this.synStream(rs, flags, length);
                break;
            }
            default: {
                throw new IOException(L.l("Unknown SPDY code {0}\n", type));
            }
        }
        long tailPos = rs.getPosition();
        long endPos = pos + (long)length;
        if (endPos < tailPos) {
            throw new IOException(L.l("Malformed length {0}\n", length));
        }
        if (tailPos < endPos) {
            rs.skip((int)(endPos - tailPos));
        }
        return isValid;
    }

    private boolean synStream(ReadStream is, int flags, int length) throws IOException {
        int serverId;
        int clientId = this.readInt(is);
        int assocStreamId = this.readInt(is);
        int pri = is.read() >> 5;
        int credentialSlot = is.read();
        System.out.println("SYN-ST: " + clientId);
        this._lastServerId = serverId = this._lastServerId + 2;
        SpdyStream stream = new SpdyStream(this, clientId, serverId, is, this._link.getWriteStream());
        int headerLen = stream.readHeaderInt();
        for (int i = 0; i < headerLen; ++i) {
            int keyLen = stream.readHeaderInt();
            String key = stream.readHeaderString(keyLen);
            int valueLen = stream.readHeaderInt();
            String value = stream.readHeaderString(valueLen);
            System.out.println("HEADER: " + key + ": " + value);
        }
        this._actor.writeStreamReply(stream);
        return true;
    }

    private int readShort(ReadStream is) throws IOException {
        int ch1 = is.read();
        int ch2 = is.read();
        if (ch2 < 0) {
            return -1;
        }
        return (ch1 << 8) + ch2;
    }

    private int readInt24(ReadStream is) throws IOException {
        int ch1 = is.read();
        int ch2 = is.read();
        int ch3 = is.read();
        if (ch3 < 0) {
            return -1;
        }
        return (ch1 << 16) + (ch2 << 8) + ch3;
    }

    private int readInt(ReadStream is) throws IOException {
        int ch1 = is.read();
        int ch2 = is.read();
        int ch3 = is.read();
        int ch4 = is.read();
        if (ch4 < 0) {
            return -1;
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    private boolean parseDataFrame(ReadStream rs, int ch) throws IOException {
        return false;
    }

    public void close() {
    }
}

