/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.snmp.types;

import com.caucho.server.snmp.SnmpRuntimeException;
import com.caucho.server.snmp.types.GetNextRequestPduValue;
import com.caucho.server.snmp.types.GetRequestPduValue;
import com.caucho.server.snmp.types.GetResponsePduValue;
import com.caucho.server.snmp.types.IntegerValue;
import com.caucho.server.snmp.types.SetRequestPduValue;
import com.caucho.server.snmp.types.SnmpValue;
import com.caucho.server.snmp.types.VarBindListValue;
import com.caucho.server.snmp.types.VarBindValue;
import java.util.Iterator;

public abstract class PduValue
extends SnmpValue {
    IntegerValue _requestId;
    IntegerValue _error;
    IntegerValue _errorIndex;
    VarBindListValue _varBindList;

    public PduValue() {
        this._requestId = IntegerValue.ZERO;
        this._error = IntegerValue.ZERO;
        this._errorIndex = IntegerValue.ZERO;
        this._varBindList = new VarBindListValue();
    }

    public PduValue(int requestId, int error, int errorIndex) {
        this._requestId = new IntegerValue(requestId);
        this._error = new IntegerValue(error);
        this._errorIndex = new IntegerValue(errorIndex);
        this._varBindList = new VarBindListValue();
    }

    public PduValue(IntegerValue requestId, IntegerValue error, IntegerValue errorIndex, VarBindListValue varBindList) {
        this._requestId = requestId;
        this._error = error;
        this._errorIndex = errorIndex;
        this._varBindList = varBindList;
    }

    public void toAsn1(StringBuilder sb) {
        StringBuilder innerSb = new StringBuilder();
        this._requestId.toAsn1(innerSb);
        this._error.toAsn1(innerSb);
        this._errorIndex.toAsn1(innerSb);
        this._varBindList.toAsn1(innerSb);
        this.header(sb, innerSb.length());
        sb.append(innerSb.toString());
    }

    public void setError(int error) {
        this._error = new IntegerValue(error);
    }

    public void setError(IntegerValue error) {
        this._error = error;
    }

    public IntegerValue getError() {
        return this._error;
    }

    public void setErrorIndex(int errorIndex) {
        this._errorIndex = new IntegerValue(errorIndex);
    }

    public void setErrorIndex(IntegerValue errorIndex) {
        this._errorIndex = errorIndex;
    }

    public IntegerValue getErrorIndex() {
        return this._errorIndex;
    }

    public void setRequestId(int id) {
        this._requestId = new IntegerValue(id);
    }

    public void setRequestId(IntegerValue id) {
        this._requestId = id;
    }

    public IntegerValue getRequestId() {
        return this._requestId;
    }

    public void addVarBind(VarBindValue obj) {
        this._varBindList.add(obj);
    }

    public void addVarBindList(VarBindListValue list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.addVarBind((VarBindValue)iter.next());
        }
    }

    public VarBindListValue getVarBindList() {
        return this._varBindList;
    }

    public static PduValue create(int type) {
        switch (type) {
            case 160: {
                return new GetRequestPduValue();
            }
            case 161: {
                return new GetNextRequestPduValue();
            }
            case 163: {
                return new SetRequestPduValue();
            }
            case 162: {
                return new GetResponsePduValue();
            }
        }
        throw new SnmpRuntimeException("invalid type: " + PduValue.typeName(type));
    }

    public static PduValue create(int type, IntegerValue requestId, IntegerValue error, IntegerValue errorIndex, VarBindListValue varBindList) {
        switch (type) {
            case 160: {
                return new GetRequestPduValue(requestId, error, errorIndex, varBindList);
            }
            case 161: {
                return new GetNextRequestPduValue(requestId, error, errorIndex, varBindList);
            }
            case 163: {
                return new SetRequestPduValue(requestId, error, errorIndex, varBindList);
            }
            case 162: {
                return new GetResponsePduValue(requestId, error, errorIndex, varBindList);
            }
        }
        throw new SnmpRuntimeException("invalid type: " + PduValue.typeName(type));
    }
}

