/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianDebugOutputStream;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.server.session.SessionSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HessianSessionSerializer
extends SessionSerializer {
    private static final Logger log = Logger.getLogger(HessianSessionSerializer.class.getName());
    private Hessian2Output _out;

    public HessianSessionSerializer(OutputStream os) {
        this(os, Thread.currentThread().getContextClassLoader());
    }

    public HessianSessionSerializer(OutputStream os, ClassLoader loader) {
        this(os, new SerializerFactory(loader));
    }

    public HessianSessionSerializer(OutputStream os, SerializerFactory factory) {
        if (log.isLoggable(Level.FINEST)) {
            os = new HessianDebugOutputStream(os, log, Level.FINEST);
        }
        this._out = new Hessian2Output(os);
        this._out.setSerializerFactory(factory);
    }

    public void setSerializeCollectionType(boolean isEnable) {
        this._out.getSerializerFactory().setSendCollectionType(isEnable);
    }

    public void writeInt(int v) throws IOException {
        this._out.writeInt(v);
    }

    public void writeObject(Object v) throws IOException {
        this._out.writeObject(v);
    }

    public void close() {
        Hessian2Output out = this._out;
        this._out = null;
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
    }
}

