/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.security.AbstractConstraint;
import com.caucho.server.security.AuthorizationResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityFilterChain
implements FilterChain {
    private FilterChain _next;
    private ServletContext _webApp;
    private AbstractConstraint[] _constraints;
    private HashMap<String, AbstractConstraint[]> _methodMap;

    SecurityFilterChain(FilterChain next) {
        this._next = next;
    }

    public void setWebApp(ServletContext app) {
        this._webApp = app;
    }

    public void setConstraints(ArrayList<AbstractConstraint> constraints) {
        this._constraints = new AbstractConstraint[constraints.size()];
        constraints.toArray(this._constraints);
    }

    public void setMethodMap(HashMap<String, AbstractConstraint[]> methodMap) {
        this._methodMap = methodMap;
    }

    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        CauchoRequest req = (CauchoRequest)request;
        CauchoResponse res = (CauchoResponse)response;
        AbstractConstraint[] constraints = null;
        if (this._methodMap != null) {
            constraints = this._methodMap.get(req.getMethod());
        }
        if (constraints == null) {
            constraints = this._constraints;
        }
        AuthorizationResult result = AuthorizationResult.NONE;
        boolean isPrivateCache = false;
        if (constraints != null) {
            for (AbstractConstraint constraint : constraints) {
                result = constraint.isAuthorized(req, res, this._webApp);
                if (constraint.isPrivateCache()) {
                    isPrivateCache = true;
                }
                if (!result.isFallthrough()) break;
            }
        }
        if (isPrivateCache) {
            res.setPrivateCache(true);
        }
        if (req.isLoginRequested() && req.login(result.isFail()) && result.isResponseSent()) {
            return;
        }
        if (result.isFail()) {
            if (!result.isResponseSent() && !res.isCommitted() && res.getStatus() / 100 == 2) {
                res.sendError(403);
            }
            return;
        }
        this._next.doFilter(request, response);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._webApp + "," + this._next + "]";
    }
}

