/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.server.security.AbstractConstraint;
import com.caucho.server.security.AuthorizationResult;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RoleConstraint
extends AbstractConstraint {
    private String[] _roles;

    public void addRoleName(String role) {
        if (this._roles == null) {
            this._roles = new String[]{role};
        } else {
            String[] newRoles = new String[this._roles.length + 1];
            System.arraycopy(this._roles, 0, newRoles, 0, this._roles.length);
            newRoles[this._roles.length] = role;
            this._roles = newRoles;
        }
    }

    public boolean needsAuthentication() {
        return this._roles != null && this._roles.length > 0;
    }

    public AuthorizationResult isAuthorized(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        Principal user = request.getUserPrincipal();
        if (user == null) {
            return AuthorizationResult.DENY;
        }
        for (int i = 0; this._roles != null && i < this._roles.length; ++i) {
            String role = this._roles[i];
            if (role.equals("*")) {
                return AuthorizationResult.DEFAULT_ALLOW;
            }
            if (!request.isUserInRole(role)) continue;
            return AuthorizationResult.DEFAULT_ALLOW;
        }
        return AuthorizationResult.DENY;
    }

    public String toString() {
        CharBuffer cb = new CharBuffer();
        cb.append(this.getClass().getSimpleName());
        cb.append("[");
        for (int i = 0; i < this._roles.length; ++i) {
            if (i != 0) {
                cb.append(',');
            }
            cb.append(this._roles[i]);
        }
        cb.append("]");
        return cb.close();
    }
}

