/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.make.DependencyContainer;
import com.caucho.server.rewrite.AbstractRuleWithConditions;
import com.caucho.server.rewrite.DispatchRule;
import com.caucho.server.rewrite.ErrorRule;
import com.caucho.server.rewrite.FilterChainMapper;
import com.caucho.server.rewrite.ForwardRule;
import com.caucho.server.rewrite.ImportRule;
import com.caucho.server.rewrite.LoadBalanceRule;
import com.caucho.server.rewrite.MovedRule;
import com.caucho.server.rewrite.ProxyRule;
import com.caucho.server.rewrite.RedirectRule;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.server.rewrite.RewriteRule;
import com.caucho.server.rewrite.Rule;
import com.caucho.server.rewrite.SetRule;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.vfs.PersistentDependency;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;

public class MatchRule
extends AbstractRuleWithConditions
implements AlarmListener {
    private static final L10N L = new L10N(MatchRule.class);
    private DependencyContainer _depend = new DependencyContainer();
    private ArrayList<Rule> _ruleList = new ArrayList();
    private FilterChainMapper _lastFilterChainMapper = new LastFilterChainMapper();
    private Rule _firstRule;
    private Rule _lastRule;
    private Alarm _alarm;

    protected MatchRule(RewriteDispatch rewriteDispatch) {
        super(rewriteDispatch);
        super.setPassFilterChainMapper(new FirstFilterChainMapper());
    }

    public String getTagName() {
        return "match";
    }

    public boolean isModified() {
        return this._depend.isModified();
    }

    public void addDependency(PersistentDependency depend) {
        this._depend.add(depend);
    }

    public void setPassFilterChainMapper(FilterChainMapper nextFilterChainMapper) {
    }

    private void add(Rule rule) {
        if (this._firstRule == null) {
            this._firstRule = rule;
        }
        if (this._lastRule != null) {
            this._lastRule.setPassFilterChainMapper(rule);
            this._lastRule.setFailFilterChainMapper(rule);
        }
        rule.setPassFilterChainMapper(this._lastFilterChainMapper);
        rule.setFailFilterChainMapper(this._lastFilterChainMapper);
        this._lastRule = rule;
        this._ruleList.add(rule);
    }

    public DispatchRule createDispatch() {
        return new DispatchRule(this.getRewriteDispatch());
    }

    public void addDispatch(DispatchRule dispatch) {
        this.add(dispatch);
    }

    public ErrorRule createForbidden() {
        return new ErrorRule(this.getRewriteDispatch(), 403);
    }

    public void addForbidden(ErrorRule forbidden) {
        this.add(forbidden);
    }

    public ForwardRule createForward() {
        return new ForwardRule(this.getRewriteDispatch());
    }

    public void addForward(ForwardRule forward) {
        this.add(forward);
    }

    public ErrorRule createGone() {
        return new ErrorRule(this.getRewriteDispatch(), 410);
    }

    public void addGone(ErrorRule gone) {
        this.add(gone);
    }

    public ImportRule createImport() {
        return new ImportRule(this.getRewriteDispatch());
    }

    public void addImport(ImportRule importRule) {
        this.add(importRule);
    }

    public LoadBalanceRule createLoadBalance() {
        WebApp webApp = this.getRewriteDispatch().getWebApp();
        if (webApp == null) {
            throw new ConfigException(L.l("<load-balance> requires a web-app.  Host-based <rewrite-dispatch> can not use <load-balance>."));
        }
        return new LoadBalanceRule(this.getRewriteDispatch(), webApp);
    }

    public void addLoadBalance(LoadBalanceRule loadBalance) {
        this.add(loadBalance);
    }

    public ProxyRule createProxy() {
        WebApp webApp = this.getRewriteDispatch().getWebApp();
        if (webApp == null) {
            throw new ConfigException(L.l("<proxy> requires a web-app.  Host-based <rewrite-dispatch> can not use <proxy>."));
        }
        return new ProxyRule(this.getRewriteDispatch(), webApp);
    }

    public void addProxy(ProxyRule proxy) {
        this.add(proxy);
    }

    public MatchRule createMatch() {
        return new MatchRule(this.getRewriteDispatch());
    }

    public void addMatch(MatchRule match) {
        this.add(match);
    }

    public MovedRule createMovedPermanently() {
        return new MovedRule(this.getRewriteDispatch(), 301);
    }

    public void addMovedPermanently(MovedRule moved) {
        this.add(moved);
    }

    public ErrorRule createNotFound() {
        return new ErrorRule(this.getRewriteDispatch(), 404);
    }

    public void addNotFound(ErrorRule notFound) {
        this.add(notFound);
    }

    public RedirectRule createRedirect() {
        return new RedirectRule(this.getRewriteDispatch());
    }

    public void addRedirect(RedirectRule redirect) {
        this.add(redirect);
    }

    public RewriteRule createRewrite() {
        return new RewriteRule(this.getRewriteDispatch());
    }

    public void addRewrite(RewriteRule rewrite) {
        this.add(rewrite);
    }

    public SetRule createSet() {
        return new SetRule(this.getRewriteDispatch());
    }

    public void addSet(SetRule set) {
        this.add(set);
    }

    @PostConstruct
    public void init() {
        super.init();
        this._ruleList.trimToSize();
        this.register();
        if (this._depend.size() > 0) {
            this._alarm = new Alarm(this);
            this.handleAlarm(this._alarm);
        }
    }

    public String rewriteUri(String uri, String queryString) {
        return uri;
    }

    public FilterChain dispatch(String uri, String queryString, FilterChain accept, FilterChainMapper next) throws ServletException {
        return null;
    }

    public synchronized void register() {
        super.register();
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        if (this._ruleList != null) {
            ruleList.addAll(this._ruleList);
        }
        for (Rule rule : ruleList) {
            rule.register();
        }
    }

    public synchronized void unregister() {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        if (this._ruleList != null) {
            ruleList.addAll(this._ruleList);
        }
        for (Rule rule : ruleList) {
            rule.unregister();
        }
        super.unregister();
    }

    public void handleAlarm(Alarm alarm) {
        if (this._ruleList != null) {
            if (this._depend.isModified()) {
                this.getRewriteDispatch().clearCache();
            } else {
                long time = this._depend.getCheckInterval();
                if (time >= 0L && time < 5000L) {
                    time = 5000L;
                }
                if (time > 0L) {
                    alarm.queue(time);
                }
            }
        }
    }

    public void destroy() {
        this.unregister();
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        if (this._ruleList != null) {
            ruleList.addAll(this._ruleList);
        }
        this._ruleList = null;
        for (Rule rule : ruleList) {
            rule.destroy();
        }
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
        super.destroy();
    }

    private class LastFilterChainMapper
    implements FilterChainMapper {
        private LastFilterChainMapper() {
        }

        public FilterChain map(String uri, String queryString, FilterChain accept) throws ServletException {
            FilterChainMapper failFilterChainMapper = MatchRule.this.getFailFilterChainMapper();
            if (failFilterChainMapper != null) {
                return failFilterChainMapper.map(uri, queryString, accept);
            }
            return accept;
        }
    }

    private class FirstFilterChainMapper
    implements FilterChainMapper {
        private FirstFilterChainMapper() {
        }

        public FilterChain map(String uri, String queryString, FilterChain accept) throws ServletException {
            if (MatchRule.this._firstRule != null) {
                return MatchRule.this._firstRule.map(uri, queryString, accept);
            }
            return MatchRule.this._lastFilterChainMapper.map(uri, queryString, accept);
        }
    }
}

