/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.VersionFactory;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudSystem;
import com.caucho.cloud.topology.TopologyService;
import com.caucho.config.ConfigAdmin;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.ConfigMXBean;
import com.caucho.management.server.ResinMXBean;
import com.caucho.management.server.ServerMXBean;
import com.caucho.management.server.ThreadPoolMXBean;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.resin.MemoryAdmin;
import com.caucho.server.resin.Resin;
import com.caucho.server.resin.ThreadPoolAdmin;
import com.caucho.server.util.CauchoSystem;
import java.util.Collection;

public class ResinAdmin
extends AbstractManagedObject
implements ResinMXBean {
    private final Resin _resin;
    private ThreadPoolAdmin _threadPoolAdmin;

    public ResinAdmin(Resin resin) {
        this._resin = resin;
        this.registerSelf();
        this._threadPoolAdmin = ThreadPoolAdmin.create();
        this._threadPoolAdmin.register();
        MemoryAdmin.create();
    }

    public String getName() {
        return null;
    }

    public ClusterMXBean[] getClusters() {
        CloudSystem system = TopologyService.getCurrentSystem();
        CloudCluster[] clusters = system.getClusterList();
        ClusterMXBean[] mxClusters = new ClusterMXBean[clusters.length];
        for (int i = 0; i < clusters.length; ++i) {
            mxClusters[i] = clusters[i].getAdmin();
        }
        return mxClusters;
    }

    public ThreadPoolMXBean getThreadPoolAdmin() {
        return this._threadPoolAdmin;
    }

    public ConfigMXBean[] getConfigs() {
        Collection<ConfigMXBean> beans = ConfigAdmin.getMBeans(this._resin.getClassLoader());
        ConfigMXBean[] array = new ConfigMXBean[beans.size()];
        beans.toArray(array);
        return array;
    }

    public String getConfigFile() {
        return this._resin.getResinConf().getNativePath();
    }

    public String getConfigDirectory() {
        return this._resin.getConfDirectory().getNativePath();
    }

    public String getResinHome() {
        return this._resin.getResinHome().getNativePath();
    }

    public String getRootDirectory() {
        return this._resin.getRootDirectory().getNativePath();
    }

    public String getLogDirectory() {
        return this._resin.getLogDirectory().getNativePath();
    }

    public String getDataDirectory() {
        return this._resin.getResinDataDirectory().getNativePath();
    }

    public ServerMXBean getServer() {
        ServletService server = this._resin.getServer();
        if (server != null) {
            return server.getAdmin();
        }
        return null;
    }

    public String getVersion() {
        return VersionFactory.getFullVersion();
    }

    public boolean isProfessional() {
        return this._resin.isProfessional();
    }

    public String getLocalHost() {
        return CauchoSystem.getLocalHost();
    }

    public String getUserName() {
        return System.getProperty("user.name");
    }

    public boolean isRestart() {
        return this._resin.isRestart();
    }

    public String getWatchdogStartMessage() {
        return this._resin.getRestartMessage();
    }

    public String toString() {
        return "ResinAdmin[" + this.getObjectName() + "]";
    }
}

