/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.httpcache;

import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.service.RootDirectorySystem;
import com.caucho.server.httpcache.TempFileManager;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;

public class TempFileService
extends AbstractResinSubSystem {
    private static final L10N L = new L10N(TempFileService.class);
    private final TempFileManager _manager;

    public TempFileService(TempFileManager manager) {
        this._manager = manager;
    }

    public static TempFileService createAndAddService() {
        RootDirectorySystem rootService = RootDirectorySystem.getCurrent();
        if (rootService == null) {
            throw new IllegalStateException(L.l("{0} requires an active {1}", (Object)TempFileService.class.getSimpleName(), (Object)RootDirectorySystem.class.getSimpleName()));
        }
        Path dataDirectory = rootService.getDataDirectory();
        TempFileManager manager = new TempFileManager(dataDirectory.lookup("tmp"));
        return TempFileService.createAndAddService(manager);
    }

    public static TempFileService createAndAddService(TempFileManager manager) {
        ResinSystem system = TempFileService.preCreate(TempFileService.class);
        TempFileService service = new TempFileService(manager);
        system.addService(TempFileService.class, service);
        return service;
    }

    public static TempFileService getCurrent() {
        return ResinSystem.getCurrentService(TempFileService.class);
    }

    public TempFileManager getManager() {
        return this._manager;
    }

    public void stop() throws Exception {
        super.stop();
        this._manager.close();
    }
}

