/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.AbstractHttpResponse;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.http.ToByteResponseStream;
import com.caucho.server.httpcache.AbstractCacheEntry;
import com.caucho.server.httpcache.AbstractCacheFilterChain;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import com.caucho.vfs.ClientDisconnectException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ResponseStream
extends ToByteResponseStream {
    private static final Logger log = Logger.getLogger(ResponseStream.class.getName());
    private static final L10N L = new L10N(ResponseStream.class);
    private final byte[] _singleByteBuffer = new byte[1];
    private AbstractHttpResponse _response;
    private CauchoResponse _proxyCacheResponse;
    private AbstractCacheFilterChain _cacheInvocation;
    private OutputStream _cacheStream;
    private long _cacheMaxLength;
    private boolean _isDisableAutoFlush;
    private int _contentLength;
    private boolean _isAllowFlush = true;
    private boolean _isComplete;

    public ResponseStream() {
    }

    protected ResponseStream(AbstractHttpResponse response) {
        this.setResponse(response);
    }

    public void setResponse(AbstractHttpResponse response) {
        this._response = response;
    }

    protected AbstractHttpResponse getResponse() {
        return this._response;
    }

    public void setProxyCacheResponse(CauchoResponse response) {
        this._proxyCacheResponse = response;
    }

    public CauchoResponse getCauchoResponse() {
        return this._proxyCacheResponse;
    }

    public void start() {
        super.start();
        this._contentLength = 0;
        this._isAllowFlush = true;
        this._isDisableAutoFlush = false;
        this._cacheStream = null;
        this._proxyCacheResponse = null;
        this._isComplete = false;
    }

    public boolean isCauchoResponseStream() {
        return true;
    }

    public void setByteCacheStream(OutputStream cacheStream) {
        this._cacheStream = cacheStream;
        if (cacheStream == null) {
            return;
        }
        AbstractHttpRequest req = this._response.getRequest();
        WebApp webApp = req.getWebApp();
        this._cacheMaxLength = webApp.getCacheMaxLength();
    }

    protected OutputStream getByteCacheStream() {
        return this._cacheStream;
    }

    public boolean canWrite() {
        return true;
    }

    protected boolean setFlush(boolean flush) {
        boolean isFlush = this._isAllowFlush;
        this._isAllowFlush = flush;
        return isFlush;
    }

    public void setAutoFlush(boolean isAutoFlush) {
        this.setDisableAutoFlush(!isAutoFlush);
    }

    void setDisableAutoFlush(boolean disable) {
        this._isDisableAutoFlush = disable;
    }

    protected boolean isDisableAutoFlush() {
        return this._isDisableAutoFlush;
    }

    public final int getContentLength() {
        try {
            this.flushCharBuffer();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (this.isCommitted()) {
            return this._contentLength;
        }
        return super.getContentLength();
    }

    public void setBufferSize(int size) {
        if (this.isCommitted()) {
            throw new IllegalStateException(L.l("Buffer size cannot be set after commit"));
        }
        super.setBufferSize(size);
    }

    public boolean hasData() {
        return this.isCommitted() || this._contentLength > 0;
    }

    public boolean isCommitted() {
        if (super.isCommitted()) {
            return true;
        }
        try {
            if (this._contentLength > 0) {
                this.flushCharBuffer();
                int bufferOffset = this.getByteBufferOffset();
                if (this._contentLength <= bufferOffset) {
                    this.setCommitted();
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        return false;
    }

    public void clear() throws IOException {
        this.clearBuffer();
        if (this.isCommitted()) {
            throw new IOException(L.l("can't clear response after writing headers"));
        }
    }

    public void clearBuffer() {
        super.clearBuffer();
        if (!this.isCommitted()) {
            this._response.setHeaderWritten(false);
        }
        this.clearNext();
    }

    public boolean isCloseComplete() {
        return super.isCloseComplete() || this._isComplete;
    }

    public void clearClosed() {
    }

    protected void writeHeaders(int length) throws IOException {
        if (this.isCommitted()) {
            return;
        }
        if (!this.isCloseComplete() || this.isCharFlushing()) {
            length = -1;
        }
        CauchoResponse proxyCacheResponse = this._proxyCacheResponse;
        this._proxyCacheResponse = null;
        if (proxyCacheResponse != null) {
            proxyCacheResponse.writeHeaders(length);
        }
        this.startCaching(true);
        this._response.writeHeaders(length);
        this.setCommitted();
    }

    public final void write(int ch) throws IOException {
        this._singleByteBuffer[0] = (byte)ch;
        this.write(this._singleByteBuffer, 0, 1);
    }

    public final byte[] getBuffer() throws IOException {
        if (this.isCommitted()) {
            this.flushBuffer();
            return this.getNextBuffer();
        }
        return super.getBuffer();
    }

    public final int getBufferOffset() throws IOException {
        if (!this.isCommitted()) {
            return super.getBufferOffset();
        }
        this.flushBuffer();
        return this.getNextBufferOffset();
    }

    public final void setBufferOffset(int offset) throws IOException {
        byte[] nextBuffer;
        if (this.isClosed()) {
            this.setNextBufferOffset(this.getNextStartOffset());
            return;
        }
        if (!this.isCommitted()) {
            super.setBufferOffset(offset);
            return;
        }
        this.flushBuffer();
        int startOffset = this.getNextStartOffset();
        if (offset == startOffset) {
            this.setNextBufferOffset(offset);
            return;
        }
        int oldOffset = this.getNextBufferOffset();
        int sublen = offset - oldOffset;
        long lengthHeader = this._response.getContentLengthHeader();
        if (lengthHeader > 0L && lengthHeader < (long)(this._contentLength + sublen)) {
            nextBuffer = this.getNextBuffer();
            this.lengthException(nextBuffer, oldOffset, sublen, lengthHeader);
            sublen = (int)(lengthHeader - (long)this._contentLength);
            offset = oldOffset + sublen;
        }
        this._contentLength += sublen;
        if (this._cacheStream != null) {
            nextBuffer = this.getNextBuffer();
            this.writeCache(nextBuffer, oldOffset, sublen);
        }
        if (!this.isHead()) {
            this.setNextBufferOffset(offset);
        }
    }

    public final byte[] nextBuffer(int offset) throws IOException {
        if (!this.isCommitted()) {
            return super.nextBuffer(offset);
        }
        if (this.isClosed()) {
            return this.getNextBuffer();
        }
        this.flushBuffer();
        byte[] nextBuffer = this.getNextBuffer();
        int startOffset = this.getNextStartOffset();
        int oldOffset = this.getNextBufferOffset();
        int sublen = offset - oldOffset;
        long lengthHeader = this._response.getContentLengthHeader();
        if (lengthHeader > 0L && lengthHeader < (long)(this._contentLength + sublen)) {
            this.lengthException(nextBuffer, startOffset, sublen, lengthHeader);
            sublen = (int)(lengthHeader - (long)this._contentLength);
        }
        this._contentLength += sublen;
        offset = oldOffset + sublen;
        if (this.isHead()) {
            return nextBuffer;
        }
        if (this._cacheStream != null) {
            this.writeCache(nextBuffer, oldOffset, sublen);
        }
        return this.writeNextBuffer(offset);
    }

    protected final void writeNext(byte[] buf, int offset, int length, boolean isFinished) throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (this._isDisableAutoFlush && !isFinished) {
            throw new IOException(L.l("auto-flushing has been disabled"));
        }
        int bufferOffset = this.getNextBufferOffset();
        if (length == 0 && bufferOffset == 0) {
            return;
        }
        int bufferStart = this.getNextStartOffset();
        if (length == 0 && bufferStart == bufferOffset) {
            return;
        }
        long contentLengthHeader = this._response.getContentLengthHeader();
        if (0L < contentLengthHeader && contentLengthHeader < (long)(length + this._contentLength)) {
            if (this.lengthException(buf, offset, length, contentLengthHeader)) {
                return;
            }
            length = (int)(contentLengthHeader - (long)this._contentLength);
        }
        if (this.isHead()) {
            return;
        }
        if (this._cacheStream != null) {
            this.writeCache(buf, offset, length);
        }
        byte[] buffer = this.getNextBuffer();
        int writeLength = length;
        while (writeLength > 0) {
            int sublen = buffer.length - bufferOffset;
            if (writeLength < sublen) {
                sublen = writeLength;
            }
            System.arraycopy(buf, offset, buffer, bufferOffset, sublen);
            offset += sublen;
            bufferOffset += sublen;
            this._contentLength += sublen;
            if ((writeLength -= sublen) <= 0) continue;
            buffer = this.writeNextBuffer(bufferOffset);
            bufferOffset = bufferStart = this.getNextStartOffset();
        }
        if (bufferOffset < buffer.length) {
            this.setNextBufferOffset(bufferOffset);
        } else {
            this.writeNextBuffer(bufferOffset);
        }
    }

    private boolean lengthException(byte[] buf, int offset, int length, long contentLengthHeader) {
        if (!(this._response.isConnectionClosed() || this.isHead() || this.isClosed() || contentLengthHeader >= (long)this._contentLength)) {
            AbstractHttpRequest request = this._response.getRequest();
            String msg = L.l("{0}: Can't write {1} extra bytes beyond the content-length header {2}.  Check that the Content-Length header correctly matches the expected bytes, and ensure that any filter which modifies the content also suppresses the content-length (to use chunked encoding).", (Object)request.getRequestURL(), (Object)("" + (length + this._contentLength)), (Object)("" + contentLengthHeader));
            log.fine(msg);
            return false;
        }
        for (int i = (int)((long)offset + contentLengthHeader - (long)this._contentLength); i < offset + length; ++i) {
            byte ch = buf[i];
            if (ch == 13 || ch == 10 || ch == 32 || ch == 9) continue;
            AbstractHttpRequest request = this._response.getRequest();
            String graph = "";
            if (Character.isLetterOrDigit((char)ch)) {
                graph = "'" + (char)ch + "', ";
            }
            String msg = L.l("{0}: tried to write {1} bytes with content-length {2} (At {3}char={4}).  Check that the Content-Length header correctly matches the expected bytes, and ensure that any filter which modifies the content also suppresses the content-length (to use chunked encoding).", (Object)request.getRequestURL(), (Object)("" + (length + this._contentLength)), (Object)("" + contentLengthHeader), (Object)graph, (Object)("" + ch));
            log.fine(msg);
            break;
        }
        return (length = (int)(contentLengthHeader - (long)this._contentLength)) <= 0;
    }

    public final void flush() throws IOException {
        this._isDisableAutoFlush = false;
        if (this._isAllowFlush && !this.isClosed()) {
            int bufferStart;
            this.flushBuffer();
            int bufferOffset = this.getNextBufferOffset();
            if (bufferOffset > 0 && (bufferStart = this.getNextStartOffset()) != bufferOffset) {
                this.writeNextBuffer(bufferOffset);
            }
            this.flushNext();
        }
    }

    public void flushByte() throws IOException {
        this.flush();
    }

    public void flushChar() throws IOException {
        this.flush();
    }

    protected void closeImpl() throws IOException {
        block2: {
            try {
                this.closeBuffer();
                this.writeTail(true);
                this.closeCache();
                this.closeNext();
            }
            catch (ClientDisconnectException e) {
                this._response.clientDisconnect();
                if (this._response.isIgnoreClientDisconnect()) break block2;
                throw e;
            }
        }
    }

    private void closeBuffer() throws IOException {
        this._isDisableAutoFlush = false;
        this.flushCharBuffer();
        this._isAllowFlush = true;
        this.flushBuffer();
        if (!this._response.isHeaderWritten()) {
            this.writeHeaders(-1);
        }
    }

    protected void startCaching(boolean isByte) {
        int contentLength;
        String charEncoding;
        String contentType;
        ArrayList<String> values;
        ArrayList<String> keys;
        HttpServletResponseImpl res = this._response.getRequest().getResponseFacade();
        if (res == null || res.getStatus() != 200 || res.isDisableCache()) {
            return;
        }
        if (this._cacheInvocation != null) {
            return;
        }
        AbstractCacheFilterChain cacheInvocation = res.getCacheInvocation();
        if (cacheInvocation == null) {
            return;
        }
        this._cacheInvocation = cacheInvocation;
        HttpServletRequestImpl req = this._response.getRequest().getRequestFacade();
        AbstractCacheEntry newCacheEntry = cacheInvocation.startCaching(req, res, keys = res.getHeaderKeys(), values = res.getHeaderValues(), contentType = res.getContentTypeImpl(), charEncoding = res.getCharacterEncodingImpl(), contentLength = -1);
        if (newCacheEntry != null) {
            if (isByte) {
                this.setByteCacheStream(newCacheEntry.openOutputStream());
            } else {
                this.setCharCacheStream(newCacheEntry.openWriter());
            }
        }
    }

    private void writeCache(byte[] buf, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        if (this._cacheMaxLength < (long)this._contentLength) {
            this.killCaching();
        } else {
            this._cacheStream.write(buf, offset, length);
        }
    }

    public void killCaching() {
        AbstractCacheFilterChain cacheInvocation = this._cacheInvocation;
        if (cacheInvocation != null) {
            HttpServletResponseImpl res = this._response.getRequest().getResponseFacade();
            cacheInvocation.killCaching(res);
            this.setByteCacheStream(null);
            this.setCharCacheStream(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeCache() {
        HttpServletResponseImpl res = this._response.getRequest().getResponseFacade();
        HttpServletRequestImpl req = this._response.getRequest().getRequestFacade();
        if (req == null) {
            return;
        }
        if (req.isAsyncStarted()) {
            return;
        }
        try {
            block12: {
                try {
                    AbstractCacheFilterChain cache;
                    this._isComplete = true;
                    this.closeBuffer();
                    if (!this.isNextValid()) {
                        this.killCaching();
                    }
                    OutputStream cacheStream = this.getByteCacheStream();
                    this.setByteCacheStream(null);
                    Writer cacheWriter = this.getCharCacheStream();
                    this.setCharCacheStream(null);
                    if (cacheStream != null) {
                        cacheStream.close();
                    }
                    if (cacheWriter != null) {
                        cacheWriter.close();
                    }
                    if ((cache = this._cacheInvocation) == null || res == null) break block12;
                    this._cacheInvocation = null;
                    WebApp webApp = res.getRequest().getWebApp();
                    if (webApp == null || !webApp.isActive()) break block12;
                    cache.finishCaching(res);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                    Object var8_9 = null;
                    AbstractCacheFilterChain cache = this._cacheInvocation;
                    this._cacheInvocation = null;
                    if (cache != null) {
                        cache.killCaching(res);
                    }
                }
            }
            Object var8_8 = null;
            AbstractCacheFilterChain cache = this._cacheInvocation;
            this._cacheInvocation = null;
            if (cache != null) {
                cache.killCaching(res);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            AbstractCacheFilterChain cache = this._cacheInvocation;
            this._cacheInvocation = null;
            if (cache != null) {
                cache.killCaching(res);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCache() {
        AbstractCacheFilterChain cache = this._cacheInvocation;
        this._cacheInvocation = null;
        HttpServletResponseImpl res = this._response.getRequest().getResponseFacade();
        try {
            block8: {
                try {
                    OutputStream cacheStream = this.getByteCacheStream();
                    this.setByteCacheStream(null);
                    Writer cacheWriter = this.getCharCacheStream();
                    this.setCharCacheStream(null);
                    if (cacheStream != null) {
                        cacheStream.close();
                    }
                    if (cacheWriter == null) break block8;
                    cacheWriter.close();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                    Object var6_7 = null;
                    if (cache != null) {
                        cache.killCaching(res);
                    }
                }
            }
            Object var6_6 = null;
            if (cache != null) {
                cache.killCaching(res);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (cache != null) {
                cache.killCaching(res);
            }
            throw throwable;
        }
    }

    protected final boolean isNextValid() {
        return !this._response.isConnectionClosed();
    }

    protected void clearNext() {
    }

    protected abstract byte[] getNextBuffer();

    protected int getNextStartOffset() {
        return 0;
    }

    protected abstract int getNextBufferOffset() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setNextBufferOffset(int offset) throws IOException {
        boolean isValid = false;
        try {
            try {
                this.setNextBufferOffsetImpl(offset);
                isValid = true;
            }
            catch (ClientDisconnectException e) {
                if (!this._response.isIgnoreClientDisconnect()) {
                    throw e;
                }
                Object var5_4 = null;
                if (!isValid) {
                    this._response.clientDisconnect();
                }
            }
            Object var5_3 = null;
            if (!isValid) {
                this._response.clientDisconnect();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!isValid) {
                this._response.clientDisconnect();
            }
            throw throwable;
        }
    }

    protected abstract void setNextBufferOffsetImpl(int var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] writeNextBuffer(int offset) throws IOException {
        boolean isValid = false;
        try {
            byte[] buffer = this.writeNextBufferImpl(offset);
            isValid = true;
            byte[] byArray = buffer;
            Object var6_7 = null;
            if (!isValid) {
                this._response.clientDisconnect();
            }
            return byArray;
        }
        catch (ClientDisconnectException e) {
            try {
                if (!this._response.isIgnoreClientDisconnect()) {
                    throw e;
                }
                log.log(Level.FINER, e.toString(), e);
                byte[] byArray = this.getNextBuffer();
                Object var6_8 = null;
                if (!isValid) {
                    this._response.clientDisconnect();
                }
                return byArray;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var6_9 = null;
                    if (isValid) break block7;
                    this._response.clientDisconnect();
                }
                throw throwable;
            }
        }
    }

    protected abstract byte[] writeNextBufferImpl(int var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushNext() throws IOException {
        boolean isValid = false;
        try {
            try {
                this.flushNextImpl();
                isValid = true;
            }
            catch (ClientDisconnectException e) {
                if (!this._response.isIgnoreClientDisconnect()) {
                    throw e;
                }
                Object var4_3 = null;
                if (!isValid) {
                    this._response.clientDisconnect();
                }
            }
            Object var4_2 = null;
            if (!isValid) {
                this._response.clientDisconnect();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!isValid) {
                this._response.clientDisconnect();
            }
            throw throwable;
        }
    }

    protected abstract void flushNextImpl() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void closeNext() throws IOException {
        boolean isValid = false;
        try {
            this.closeNextImpl();
            isValid = true;
            Object var3_2 = null;
            if (!isValid) {
                this._response.clientDisconnect();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!isValid) {
                this._response.clientDisconnect();
            }
            throw throwable;
        }
    }

    protected abstract void closeNextImpl() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeTail(boolean isComplete) throws IOException {
        boolean isValid = false;
        try {
            this.writeTailImpl(isComplete);
            isValid = true;
            Object var4_3 = null;
            if (!isValid) {
                this._response.clientDisconnect();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!isValid) {
                this._response.clientDisconnect();
            }
            throw throwable;
        }
    }

    protected void writeTailImpl(boolean isClosed) throws IOException {
    }

    protected String dbgId() {
        AbstractHttpRequest request = this._response.getRequest();
        if (request instanceof AbstractHttpRequest) {
            AbstractHttpRequest req = request;
            return req.dbgId();
        }
        return "inc ";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._response + "]";
    }
}

