/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.CauchoResponse;
import com.caucho.vfs.OutputStreamWithBuffer;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;

public abstract class AbstractResponseStream
extends OutputStreamWithBuffer {
    private State _state = State.START;

    public void setCauchoResponse(CauchoResponse res) {
    }

    public void start() {
        this._state = this._state.toStart();
    }

    public void setHead() {
        this._state = this._state.toHead();
    }

    public final boolean isHead() {
        return this._state.isHead();
    }

    public boolean isCommitted() {
        return this._state.isCommitted();
    }

    public void setCommitted() {
        this._state = this._state.toCommitted();
    }

    public boolean isClosing() {
        return this._state.isClosing();
    }

    public boolean isCloseComplete() {
        return this._state.isClosing();
    }

    public abstract boolean isCauchoResponseStream();

    public String getEncoding() {
        return null;
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
    }

    public void setOutputStreamOnly(boolean isOutputStreamOnly) {
    }

    public void setLocale(Locale locale) throws UnsupportedEncodingException {
    }

    public abstract void setBufferSize(int var1);

    public abstract int getBufferSize();

    public void setAutoFlush(boolean isAutoFlush) {
    }

    public boolean isAutoFlush() {
        return true;
    }

    public abstract int getRemaining();

    public abstract char[] getCharBuffer() throws IOException;

    public abstract int getCharOffset() throws IOException;

    public abstract void setCharOffset(int var1) throws IOException;

    public abstract char[] nextCharBuffer(int var1) throws IOException;

    public void setByteCacheStream(OutputStream cacheStream) {
        if (cacheStream != null) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }

    protected OutputStream getByteCacheStream() {
        return null;
    }

    public void setCharCacheStream(Writer cacheStream) {
        if (cacheStream != null) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }

    protected Writer getCharCacheStream() {
        return null;
    }

    public int getContentLength() {
        return 0;
    }

    public abstract void write(int var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public abstract void print(int var1) throws IOException;

    public abstract void print(char[] var1, int var2, int var3) throws IOException;

    public void clear() throws IOException {
        this.clearBuffer();
    }

    public abstract void clearBuffer();

    public abstract void flushBuffer() throws IOException;

    public void flushNext() throws IOException {
        this.flushBuffer();
    }

    public void flushByte() throws IOException {
        this.flushBuffer();
    }

    public void flushChar() throws IOException {
        this.flushBuffer();
    }

    public void sendFile(Path path, long offset, long length) throws IOException {
        path.sendfile(this, offset, length);
    }

    public void flush() throws IOException {
        this.flushByte();
    }

    protected void killCaching() {
    }

    public void completeCache() {
    }

    public boolean isClosed() {
        return this._state.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        State state = this._state;
        if (state.isClosing()) {
            return;
        }
        this._state = state.toClosing();
        try {
            this.closeImpl();
        }
        finally {
            try {
                this._state = this._state.toClose();
            }
            catch (RuntimeException e) {
                throw new RuntimeException((Object)((Object)state) + ": " + e, e);
            }
        }
    }

    protected boolean toClosing() {
        State state = this._state;
        if (state.isClosing()) {
            return false;
        }
        this._state = state.toClosing();
        return true;
    }

    protected void closeImpl() throws IOException {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + (Object)((Object)this._state) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        START{

            State toHead() {
                return HEAD;
            }

            State toCommitted() {
                return COMMITTED;
            }

            State toClosing() {
                return CLOSING;
            }
        }
        ,
        HEAD{

            boolean isHead() {
                return true;
            }

            State toHead() {
                return this;
            }

            State toCommitted() {
                return COMMITTED_HEAD;
            }

            State toClosing() {
                return CLOSING_HEAD;
            }
        }
        ,
        COMMITTED{

            boolean isCommitted() {
                return true;
            }

            State toHead() {
                return COMMITTED_HEAD;
            }

            State toCommitted() {
                return this;
            }

            State toClosing() {
                return CLOSING;
            }
        }
        ,
        COMMITTED_HEAD{

            boolean isCommitted() {
                return true;
            }

            boolean isHead() {
                return true;
            }

            State toHead() {
                return this;
            }

            State toCommitted() {
                return this;
            }

            State toClosing() {
                return CLOSING_HEAD;
            }
        }
        ,
        CLOSING{

            boolean isClosing() {
                return true;
            }

            State toHead() {
                return CLOSING_HEAD;
            }

            State toCommitted() {
                return CLOSING_COMMITTED;
            }

            State toClose() {
                return CLOSED;
            }
        }
        ,
        CLOSING_HEAD{

            boolean isHead() {
                return true;
            }

            boolean isClosing() {
                return true;
            }

            State toHead() {
                return this;
            }

            State toCommitted() {
                return CLOSING_HEAD_COMMITTED;
            }

            State toClose() {
                return CLOSED;
            }
        }
        ,
        CLOSING_COMMITTED{

            boolean isCommitted() {
                return true;
            }

            boolean isClosing() {
                return true;
            }

            State toHead() {
                return CLOSING_HEAD_COMMITTED;
            }

            State toCommitted() {
                return this;
            }

            State toClose() {
                return CLOSED;
            }
        }
        ,
        CLOSING_HEAD_COMMITTED{

            boolean isHead() {
                return true;
            }

            boolean isCommitted() {
                return true;
            }

            boolean isClosing() {
                return true;
            }

            State toHead() {
                return this;
            }

            State toCommitted() {
                return this;
            }

            State toClose() {
                return CLOSED;
            }
        }
        ,
        CLOSED{

            boolean isCommitted() {
                return true;
            }

            boolean isClosed() {
                return true;
            }

            boolean isClosing() {
                return true;
            }
        };


        boolean isHead() {
            return false;
        }

        boolean isCommitted() {
            return false;
        }

        boolean isClosing() {
            return false;
        }

        boolean isClosed() {
            return false;
        }

        State toStart() {
            return START;
        }

        State toHead() {
            throw new IllegalStateException(this.toString());
        }

        State toCommitted() {
            throw new IllegalStateException(this.toString());
        }

        State toClosing() {
            throw new IllegalStateException(this.toString());
        }

        State toClose() {
            throw new IllegalStateException(this.toString());
        }
    }
}

