/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.i18n.CharacterEncoding;
import com.caucho.network.listen.SocketLink;
import com.caucho.security.Authenticator;
import com.caucho.security.Login;
import com.caucho.security.RoleMapManager;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.dispatch.ServletInvocation;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Form;
import com.caucho.server.http.MultipartFormParser;
import com.caucho.server.session.SessionImpl;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.CurrentTime;
import com.caucho.util.HashMapImpl;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.MultipartConfigElement;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCauchoRequest
implements CauchoRequest {
    private static final L10N L = new L10N(AbstractCauchoRequest.class);
    private static final Logger log = Logger.getLogger(AbstractCauchoRequest.class.getName());
    static final String CHAR_ENCODING = "resin.form.character.encoding";
    static final String FORM_LOCALE = "resin.form.local";
    static final String CAUCHO_CHAR_ENCODING = "caucho.form.character.encoding";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private int _sessionGroup = -1;
    private boolean _sessionIsLoaded;
    private SessionImpl _session;
    private ArrayList<Path> _removeOnExit;
    private HashMapImpl<String, String[]> _filledForm;
    private List<Part> _parts;

    public abstract CauchoResponse getResponse();

    protected void startRequest() {
        this._sessionGroup = -1;
        this._sessionIsLoaded = false;
        this._session = null;
        this._removeOnExit = null;
        this._filledForm = null;
        this._parts = null;
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        int p;
        String pathInfo;
        if (path == null || path.length() == 0) {
            return null;
        }
        if (path.charAt(0) == '/') {
            return this.getWebApp().getRequestDispatcher(path);
        }
        CharBuffer cb = new CharBuffer();
        WebApp webApp = this.getWebApp();
        String servletPath = this.getPageServletPath();
        if (servletPath != null) {
            cb.append(servletPath);
        }
        if ((pathInfo = this.getPagePathInfo()) != null) {
            cb.append(pathInfo);
        }
        if ((p = cb.lastIndexOf('/')) >= 0) {
            cb.setLength(p);
        }
        cb.append('/');
        cb.append(path);
        if (webApp != null) {
            return webApp.getRequestDispatcher(cb.toString());
        }
        return null;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return this.getParameterNamesImpl();
    }

    public final Enumeration<String> getParameterNamesImpl() {
        if (this._filledForm == null) {
            this._filledForm = this.parseQueryImpl();
        }
        return Collections.enumeration(this._filledForm.keySet());
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.getParameterMapImpl();
    }

    public final Map<String, String[]> getParameterMapImpl() {
        if (this._filledForm == null) {
            this._filledForm = this.parseQueryImpl();
        }
        return Collections.unmodifiableMap(this._filledForm);
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.getParameterValuesImpl(name);
    }

    public final String[] getParameterValuesImpl(String name) {
        if (this._filledForm == null) {
            this._filledForm = this.parseQueryImpl();
        }
        return this._filledForm.get(name);
    }

    @Override
    public String getParameter(String name) {
        return this.getParameterImpl(name);
    }

    public final String getParameterImpl(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    @Override
    public Collection<Part> getParts() throws IOException, ServletException {
        ServletInvocation invocation = this.getInvocation();
        MultipartConfigElement multipartConfig = invocation.getMultipartConfig();
        if (multipartConfig == null) {
            throw new ServletException(L.l("multipart-form is disabled; check @MultipartConfig annotation on '{0}'.", (Object)invocation.getServletName()));
        }
        String contentType = this.getContentType();
        if (contentType == null || !this.getContentType().startsWith("multipart/form-data")) {
            throw new ServletException("Content-Type must be of 'multipart/form-data'.");
        }
        if (this._filledForm == null) {
            this._filledForm = this.parseQueryImpl();
        }
        return this._parts;
    }

    @Override
    public boolean isMultipartEnabled() {
        ServletInvocation invocation = this.getInvocation();
        if (invocation == null) {
            return false;
        }
        return invocation.getMultipartConfig() != null;
    }

    @Override
    public Part getPart(String name) throws IOException, ServletException {
        Collection<Part> parts = this.getParts();
        if (parts == null) {
            return null;
        }
        for (Part part : parts) {
            if (!name.equals(part.getName())) continue;
            return part;
        }
        return null;
    }

    @Override
    public abstract AbstractHttpRequest getAbstractHttpRequest();

    public ServletService getServer() {
        return this.getAbstractHttpRequest().getServer();
    }

    protected HashMapImpl<String, String[]> parseQueryImpl() {
        HashMapImpl<String, String[]> form = new HashMapImpl<String, String[]>();
        this.parseGetQueryImpl(form);
        this.parsePostQueryImpl(form);
        return form;
    }

    protected void parseGetQueryImpl(HashMapImpl<String, String[]> form) {
        AbstractHttpRequest request = this.getAbstractHttpRequest();
        try {
            String queryEncoding;
            String query = this.getInvocation().getQueryString();
            if (query == null) {
                return;
            }
            Form formParser = request != null ? request.getFormParser() : new Form();
            String charEncoding = this.getCharacterEncoding();
            if (charEncoding == null) {
                Locale locale;
                charEncoding = (String)this.getAttribute(CAUCHO_CHAR_ENCODING);
                if (charEncoding == null) {
                    charEncoding = (String)this.getAttribute(CHAR_ENCODING);
                }
                if (charEncoding == null && (locale = (Locale)this.getAttribute(FORM_LOCALE)) != null) {
                    charEncoding = Encoding.getMimeName(locale);
                }
            }
            if ((queryEncoding = charEncoding) == null && this.getServer() != null) {
                queryEncoding = this.getServer().getURLCharacterEncoding();
            }
            if (queryEncoding == null) {
                queryEncoding = CharacterEncoding.getLocalEncoding();
            }
            String javaEncoding = Encoding.getJavaName(queryEncoding);
            formParser.parseQueryString(form, query, javaEncoding, true);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    protected void parsePostQueryImpl(HashMapImpl<String, String[]> form) {
        block25: {
            AbstractHttpRequest request = this.getAbstractHttpRequest();
            if (request == null) {
                return;
            }
            try {
                Object paramMax;
                Object uploadMax;
                CharSegment contentType = request.getContentTypeBuffer();
                if (contentType == null) {
                    return;
                }
                Form formParser = request.getFormParser();
                long contentLength = request.getLongContentLength();
                String charEncoding = this.getCharacterEncoding();
                if (charEncoding == null) {
                    Locale locale;
                    charEncoding = (String)this.getAttribute(CAUCHO_CHAR_ENCODING);
                    if (charEncoding == null) {
                        charEncoding = (String)this.getAttribute(CHAR_ENCODING);
                    }
                    if (charEncoding == null && (locale = (Locale)this.getAttribute(FORM_LOCALE)) != null) {
                        charEncoding = Encoding.getMimeName(locale);
                    }
                }
                if (charEncoding == null) {
                    charEncoding = CharacterEncoding.getLocalEncoding();
                }
                String javaEncoding = Encoding.getJavaName(charEncoding);
                ServletInvocation invocation = this.getInvocation();
                MultipartConfigElement multipartConfig = invocation.getMultipartConfig();
                if (contentType == null || !"POST".equalsIgnoreCase(this.getMethod())) break block25;
                if (contentType.startsWith("application/x-www-form-urlencoded")) {
                    formParser.parsePostData(form, this.getInputStream(), javaEncoding, this.getWebApp().getFormParameterMax());
                    break block25;
                }
                if (!this.getWebApp().isMultipartFormEnabled() && multipartConfig == null || !contentType.startsWith("multipart/form-data")) break block25;
                int length = contentType.length();
                int i = contentType.indexOf("boundary=");
                if (i < 0) {
                    return;
                }
                long formUploadMax = this.getWebApp().getFormUploadMax();
                long parameterLengthMax = this.getWebApp().getFormParameterLengthMax();
                if (parameterLengthMax < 0L) {
                    parameterLengthMax = 0x3FFFFFFFFFFFFFFFL;
                }
                if ((uploadMax = this.getAttribute("caucho.multipart.form.upload-max")) instanceof Number) {
                    formUploadMax = ((Number)uploadMax).longValue();
                }
                if ((paramMax = this.getAttribute("caucho.multipart.form.parameter-length-max")) instanceof Number) {
                    parameterLengthMax = ((Number)paramMax).longValue();
                }
                if (formUploadMax >= 0L && formUploadMax < contentLength) {
                    this.setAttribute("caucho.multipart.form.error", L.l("Multipart form upload of '{0}' bytes was too large.", (Object)String.valueOf(contentLength)));
                    this.setAttribute("caucho.multipart.form.error.size", new Long(contentLength));
                    return;
                }
                long fileUploadMax = -1L;
                if (multipartConfig != null) {
                    formUploadMax = multipartConfig.getMaxRequestSize();
                    fileUploadMax = multipartConfig.getMaxFileSize();
                }
                if (multipartConfig != null && formUploadMax > 0L && formUploadMax < contentLength) {
                    throw new IllegalStateException(L.l("multipart form data request's Content-Length '{0}' is greater then configured in @MultipartConfig.maxRequestSize value: '{1}'", (Object)contentLength, (Object)formUploadMax));
                }
                char ch = contentType.charAt(i += "boundary=".length());
                CharBuffer boundary = new CharBuffer();
                if (ch == '\'') {
                    ++i;
                    while (i < length && contentType.charAt(i) != '\'') {
                        boundary.append(contentType.charAt(i));
                        ++i;
                    }
                } else if (ch == '\"') {
                    ++i;
                    while (i < length && contentType.charAt(i) != '\"') {
                        boundary.append(contentType.charAt(i));
                        ++i;
                    }
                } else {
                    while (i < length && (ch = contentType.charAt(i)) != ' ' && ch != ';') {
                        boundary.append(ch);
                        ++i;
                    }
                }
                this._parts = new ArrayList<Part>();
                try {
                    MultipartFormParser.parsePostData(form, this._parts, this.getStream(false), boundary.toString(), this, javaEncoding, formUploadMax, fileUploadMax, parameterLengthMax);
                }
                catch (IOException e) {
                    log.log(Level.FINE, e.toString(), e);
                    this.setAttribute("caucho.multipart.form.error", e.getMessage());
                }
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    Part createPart(String name, String contentType, Map<String, List<String>> headers, Path tempFile, String value) {
        return new PartImpl(name, contentType, headers, tempFile, value);
    }

    public final void mergeParameters(Map<String, String[]> source, Map<String, String[]> target) {
        Set<Map.Entry<String, String[]>> sourceEntries = source.entrySet();
        for (Map.Entry<String, String[]> sourceEntry : sourceEntries) {
            String[] newTargetValues;
            String key = sourceEntry.getKey();
            String[] sourceValues = sourceEntry.getValue();
            String[] targetValues = target.get(key);
            if (targetValues == null) {
                newTargetValues = sourceValues;
            } else {
                newTargetValues = new String[targetValues.length + sourceValues.length];
                System.arraycopy(targetValues, 0, newTargetValues, 0, targetValues.length);
                System.arraycopy(sourceValues, 0, newTargetValues, targetValues.length, sourceValues.length);
            }
            target.put(key, newTargetValues);
        }
    }

    public void addCloseOnExit(Path path) {
        if (this._removeOnExit == null) {
            this._removeOnExit = new ArrayList();
        }
        this._removeOnExit.add(path);
    }

    public ReadStream getStream(boolean isFlush) throws IOException {
        return this.getAbstractHttpRequest().getStream();
    }

    @Override
    public String getRealPath(String uri) {
        WebApp webApp = this.getWebApp();
        return webApp.getRealPath(uri);
    }

    @Override
    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme());
        sb.append("://");
        sb.append(this.getServerName());
        int port = this.getServerPort();
        if (port > 0 && port != 80 && port != 443) {
            sb.append(":");
            sb.append(port);
        }
        sb.append(this.getRequestURI());
        return sb;
    }

    @Override
    public String getPathTranslated() {
        String pathInfo = this.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        return this.getRealPath(pathInfo);
    }

    @Override
    public boolean isTop() {
        return false;
    }

    @Override
    public abstract boolean isSessionIdFromCookie();

    @Override
    public abstract String getSessionId();

    @Override
    public abstract void setSessionId(String var1);

    @Override
    public HttpSession getMemorySession() {
        if (this._session != null && this._session.isValid()) {
            return this._session;
        }
        return null;
    }

    @Override
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Override
    public HttpSession getSession(boolean create) {
        if (this._session != null) {
            if (this._session.isValid()) {
                return this._session;
            }
        } else if (!create && this._sessionIsLoaded) {
            return null;
        }
        this._sessionIsLoaded = true;
        this._session = this.createSession(create);
        return this._session;
    }

    public HttpSession getLoadedSession() {
        if (this._session != null && this._session.isValid()) {
            return this._session;
        }
        return null;
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        String id = this.getRequestedSessionId();
        if (id == null) {
            return false;
        }
        SessionImpl session = this._session;
        if (session == null) {
            session = (SessionImpl)this.getSession(false);
        }
        return session != null && session.isValid() && session.getId().equals(id);
    }

    private SessionImpl createSession(boolean isCreate) {
        long now;
        SessionManager manager = this.getSessionManager();
        if (manager == null) {
            return null;
        }
        String id = this.getSessionId();
        SessionImpl session = manager.createSession(isCreate, this, id, now = CurrentTime.getCurrentTime(), this.isSessionIdFromCookie());
        if (!(session == null || id != null && session.getId().equals(id))) {
            this.setSessionId(session.getId());
        }
        return session;
    }

    protected final SessionManager getSessionManager() {
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            return webApp.getSessionManager();
        }
        return null;
    }

    protected final String getSessionCookie(SessionManager manager) {
        if (this.isSecure()) {
            return manager.getSSLCookieName();
        }
        return manager.getCookieName();
    }

    public int getSessionGroup() {
        return this._sessionGroup;
    }

    void saveSession() {
        SessionImpl session = this._session;
        if (session != null) {
            session.save();
        }
    }

    protected String getRunAs() {
        return null;
    }

    protected ServletInvocation getInvocation() {
        return null;
    }

    public HttpServletRequest getRequest() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void login(String username, String password) throws ServletException {
        WebApp webApp = this.getWebApp();
        Authenticator auth = webApp.getConfiguredAuthenticator();
        if (auth == null) {
            throw new ServletException(L.l("No authentication mechanism is configured for '{0}'", (Object)this.getWebApp()));
        }
        Login login = webApp.getLogin();
        if (login == null) {
            throw new ServletException(L.l("No login mechanism is configured for '{0}'", (Object)this.getWebApp()));
        }
        if (!login.isPasswordBased()) {
            throw new ServletException(L.l("Authentication mechanism '{0}' does not support password authentication", (Object)login));
        }
        this.removeAttribute("caucho.user.name");
        this.removeAttribute("caucho.user");
        this.removeAttribute("caucho.password");
        Principal principal = login.getUserPrincipal(this);
        if (principal != null) {
            throw new ServletException(L.l("UserPrincipal object has already been established"));
        }
        this.removeAttribute("caucho.user");
        this.setAttribute("caucho.user.name", username);
        this.setAttribute("caucho.password", password);
        try {
            login.login(this, this.getResponse(), false);
        }
        finally {
            this.removeAttribute("caucho.user.name");
            this.removeAttribute("caucho.password");
        }
        principal = login.getUserPrincipal(this);
        if (principal == null) {
            throw new ServletException("can't authenticate a user");
        }
    }

    @Override
    public boolean login(boolean isFail) {
        try {
            WebApp webApp = this.getWebApp();
            if (webApp == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.finer("authentication failed, no web-app found");
                }
                this.getResponse().sendError(403);
                return false;
            }
            if (webApp.isSecure() && !this.isSecure()) {
                if (log.isLoggable(Level.FINE)) {
                    log.finer("authentication failed, requires secure");
                }
                this.getResponse().sendError(403);
                return false;
            }
            Login login = webApp.getLogin();
            if (login != null) {
                Principal user = login.login(this, this.getResponse(), isFail);
                return user != null;
            }
            if (isFail) {
                if (log.isLoggable(Level.FINE)) {
                    log.finer("authentication failed, no login module found for " + webApp);
                }
                this.getResponse().sendError(403);
                return false;
            }
            return false;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    @Override
    public abstract boolean isLoginRequested();

    @Override
    public abstract void requestLogin();

    @Override
    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            throw new ServletException(L.l("No authentication mechanism is configured for '{0}'", (Object)this.getWebApp()));
        }
        Authenticator auth = webApp.getConfiguredAuthenticator();
        if (auth == null) {
            throw new ServletException(L.l("No authentication mechanism is configured for '{0}'", (Object)this.getWebApp()));
        }
        Login login = webApp.getLogin();
        if (login == null) {
            throw new ServletException(L.l("No authentication mechanism is configured for '{0}'", (Object)this.getWebApp()));
        }
        Principal principal = login.login(this, response, true);
        return principal != null;
    }

    @Override
    public Principal getUserPrincipal() {
        CauchoResponse response;
        this.requestLogin();
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return null;
        }
        Principal user = null;
        Login login = webApp.getLogin();
        if (login != null && (user = login.getUserPrincipal(this)) != null && (response = this.getResponse()) != null) {
            response.setPrivateCache(true);
        }
        return user;
    }

    @Override
    public boolean isUserInRole(String role) {
        boolean inRole;
        Boolean result;
        RoleMapManager roleManager;
        String runAs;
        String linkRole;
        ServletInvocation invocation = this.getInvocation();
        if (invocation == null) {
            if (this.getRequest() != null) {
                return this.getRequest().isUserInRole(role);
            }
            return false;
        }
        HashMap<String, String> roleMap = invocation.getSecurityRoleMap();
        if (roleMap != null && (linkRole = roleMap.get(role)) != null) {
            role = linkRole;
        }
        if ((runAs = this.getRunAs()) != null) {
            return runAs.equals(role);
        }
        WebApp webApp = this.getWebApp();
        Principal user = this.getUserPrincipal();
        if (user == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " isUserInRole request has no getUserPrincipal value");
            }
            return false;
        }
        RoleMapManager roleMapManager = roleManager = webApp != null ? webApp.getRoleMapManager() : null;
        if (roleManager != null && (result = roleManager.isUserInRole(role, user)) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " userInRole(" + role + ")->" + result);
            }
            return result;
        }
        Login login = webApp == null ? null : webApp.getLogin();
        boolean bl = inRole = login != null && login.isUserInRole(user, role);
        if (log.isLoggable(Level.FINE)) {
            if (login == null) {
                log.fine(this + " no Login for isUserInRole");
            } else if (user == null) {
                log.fine(this + " no user for isUserInRole");
            } else if (inRole) {
                log.fine(this + " " + user + " is in role: " + role);
            } else {
                log.fine(this + " failed " + user + " in role: " + role);
            }
        }
        return inRole;
    }

    @Override
    public SocketLink getSocketLink() {
        AbstractHttpRequest request = this.getAbstractHttpRequest();
        if (request != null) {
            return request.getConnection();
        }
        return null;
    }

    protected void finishRequest() throws IOException {
        WebApp webApp;
        SessionImpl session = this._session;
        if (session == null && this.getSessionId() != null && (webApp = this.getWebApp()) != null && webApp.isActive()) {
            session = (SessionImpl)this.getSession(false);
        }
        if (session != null) {
            session.finishRequest();
        }
        if (this._removeOnExit != null) {
            for (int i = this._removeOnExit.size() - 1; i >= 0; --i) {
                Path path = this._removeOnExit.get(i);
                try {
                    path.remove();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getRequestURL() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PartImpl
    implements Part {
        private String _name;
        private Map<String, List<String>> _headers;
        private Path _tempFile;
        private String _value;
        private Path _newPath;
        private String _contentType;

        private PartImpl(String name, String contentType, Map<String, List<String>> headers, Path tempFile, String value) {
            this._name = name;
            this._contentType = contentType;
            this._headers = headers;
            this._tempFile = tempFile;
            this._value = value;
        }

        @Override
        public void delete() throws IOException {
            if (this._tempFile == null) {
                throw new IOException(L.l("Part.delete() is not applicable to part '{0}':'{1}'", (Object)this._name, (Object)this._value));
            }
            if (this._newPath != null) {
                this._newPath.remove();
            }
            this._tempFile.remove();
        }

        @Override
        public String getContentType() {
            return this._contentType;
        }

        @Override
        public String getHeader(String name) {
            List<String> values = this._headers.get(name = name.toLowerCase(Locale.ENGLISH));
            if (values != null && values.size() > 0) {
                return values.get(0);
            }
            return null;
        }

        @Override
        public Collection<String> getHeaderNames() {
            return this._headers.keySet();
        }

        @Override
        public Collection<String> getHeaders(String name) {
            name = name.toLowerCase(Locale.ENGLISH);
            return this._headers.get(name);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this._value != null) {
                String encoding = AbstractCauchoRequest.this.getCharacterEncoding();
                ByteArrayInputStream is = encoding != null ? new ByteArrayInputStream(this._value.getBytes(encoding)) : new ByteArrayInputStream(this._value.getBytes(UTF8));
                return is;
            }
            if (this._tempFile != null) {
                return this._tempFile.openRead();
            }
            throw new IllegalStateException();
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public long getSize() {
            if (this._tempFile != null) {
                return this._tempFile.getLength();
            }
            return -1L;
        }

        @Override
        public void write(String fileName) throws IOException {
            if (this._newPath != null) {
                throw new IOException(L.l("Contents of part '{0}' has already been written to '{1}'", (Object)this._name, (Object)this._newPath));
            }
            if (this._tempFile == null) {
                throw new IOException(L.l("Part.write() is not applicable to part '{0}':'{1}'", (Object)this._name, (Object)this._value));
            }
            ServletInvocation invocation = AbstractCauchoRequest.this.getInvocation();
            MultipartConfigElement mc = invocation.getMultipartConfig();
            String location = mc.getLocation().replace('\\', '/');
            fileName = fileName.replace('\\', '/');
            String file = location.charAt(location.length() - 1) != '/' && fileName.charAt(fileName.length() - 1) != '/' ? location + '/' + fileName : location + fileName;
            this._newPath = Vfs.lookup(file);
            if (this._newPath.exists()) {
                throw new IOException(L.l("File '{0}' already exists.", (Object)this._newPath));
            }
            Path parent = this._newPath.getParent();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IOException(L.l("Unable to create path '{0}'. Check permissions.", (Object)parent));
            }
            if (!this._tempFile.renameTo(this._newPath)) {
                WriteStream out = null;
                try {
                    out = this._newPath.openWrite();
                    this._tempFile.writeToStream(out);
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, L.l("Cannot write contents of '{0}' to '{1}'", (Object)this._tempFile, (Object)this._newPath), e);
                    throw e;
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
        }

        public Object getValue() {
            if (this._value != null) {
                return this._value;
            }
            if (this._tempFile != null) {
                return this._tempFile;
            }
            throw new IllegalStateException();
        }
    }
}

