/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.hmux;

import com.caucho.server.hmux.HmuxRequest;
import com.caucho.server.hmux.HmuxResponseStream;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.AbstractHttpResponse;
import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.util.CharBuffer;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.Cookie;

public class HmuxResponse
extends AbstractHttpResponse {
    private final HmuxRequest _req;
    private final CharBuffer _cb = new CharBuffer();

    HmuxResponse(HmuxRequest request, WriteStream rawWrite) {
        super(request);
        this._req = request;
        if (this._req == null) {
            throw new NullPointerException();
        }
    }

    protected AbstractResponseStream createResponseStream() {
        HmuxRequest request = (HmuxRequest)this.getRequest();
        return new HmuxResponseStream(request, this, request.getRawWrite());
    }

    public void setHeaderWritten(boolean isWritten) {
    }

    protected boolean writeHeadersInt(int length, boolean isHead) throws IOException {
        AbstractHttpRequest request = this.getRequest();
        if (!request.hasRequest()) {
            return false;
        }
        HttpServletResponseImpl response = request.getResponseFacade();
        int statusCode = response.getStatus();
        CharBuffer cb = this._cb;
        cb.clear();
        cb.append((char)(statusCode / 100 % 10 + 48));
        cb.append((char)(statusCode / 10 % 10 + 48));
        cb.append((char)(statusCode % 10 + 48));
        cb.append(' ');
        cb.append(response.getStatusMessage());
        this._req.writeStatus(cb);
        if (statusCode >= 400) {
            this.removeHeader("ETag");
            this.removeHeader("Last-Modified");
        } else if (response.isNoCache()) {
            this.removeHeader("ETag");
            this.removeHeader("Last-Modified");
            this.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
            this._req.writeHeader("Cache-Control", "no-cache");
        } else if (response.isPrivateCache()) {
            this._req.writeHeader("Cache-Control", "private");
        }
        int load = (int)(1000.0 * this._req.getServer().getCpuLoad());
        if (CurrentTime.isTest()) {
            load = 0;
        }
        this._req.writeString(77, "cpu-load");
        this._req.writeString(83, String.valueOf(load));
        ArrayList<String> headerKeys = this.getHeaderKeys();
        ArrayList<String> headerValues = this.getHeaderValues();
        int size = headerKeys.size();
        for (int i = 0; i < size; ++i) {
            String key = headerKeys.get(i);
            String value = headerValues.get(i);
            this._req.writeHeader(key, value);
        }
        long contentLength = this.getContentLengthHeader();
        if (contentLength >= 0L) {
            cb.clear();
            cb.append(contentLength);
            this._req.writeHeader("Content-Length", cb);
        } else if (length >= 0) {
            cb.clear();
            cb.append(length);
            this._req.writeHeader("Content-Length", cb);
        }
        HttpServletResponseImpl responseFacade = request.getResponseFacade();
        long now = CurrentTime.getCurrentTime();
        ArrayList<Cookie> cookiesOut = responseFacade.getCookies();
        if (cookiesOut != null) {
            size = cookiesOut.size();
            for (int i = 0; i < size; ++i) {
                Cookie cookie = cookiesOut.get(i);
                int cookieVersion = cookie.getVersion();
                cb.clear();
                this.fillCookie(cb, cookie, now, cookieVersion, false);
                this._req.writeHeader("Set-Cookie", cb);
                if (cookieVersion <= 0) continue;
                cb.clear();
                this.fillCookie(cb, cookie, now, cookieVersion, true);
                this._req.writeHeader("Set-Cookie2", cb);
            }
        }
        String contentType = responseFacade.getContentTypeImpl();
        String charEncoding = responseFacade.getCharacterEncodingImpl();
        if (contentType != null) {
            if (charEncoding != null) {
                this._req.writeHeader("Content-Type", contentType + "; charset=" + charEncoding);
            } else {
                this._req.writeHeader("Content-Type", contentType);
            }
        }
        this._req.sendHeader();
        return false;
    }
}

