/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.db.blob.BlobInputStream;
import com.caucho.distcache.CacheSerializer;
import com.caucho.env.distcache.CacheDataBacking;
import com.caucho.env.service.ResinSystem;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.CacheStoreManager;
import com.caucho.server.distcache.DataStore;
import com.caucho.server.distcache.DataStreamSource;
import com.caucho.server.distcache.MnodeEntry;
import com.caucho.server.distcache.MnodeValue;
import com.caucho.util.HashKey;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.util.NullOutputStream;
import com.caucho.vfs.Crc64InputStream;
import com.caucho.vfs.Crc64OutputStream;
import com.caucho.vfs.StreamSource;
import com.caucho.vfs.TempOutputStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LocalDataManager {
    private static final L10N L = new L10N(LocalDataManager.class);
    private static final Logger log = Logger.getLogger(LocalDataManager.class.getName());
    private final String _serverId = ResinSystem.getCurrentId();
    private final CacheStoreManager _storeManager;

    LocalDataManager(CacheStoreManager storeManager) {
        this._storeManager = storeManager;
    }

    private CacheStoreManager getStoreManager() {
        return this._storeManager;
    }

    private CacheDataBacking getDataBacking() {
        return this.getStoreManager().getDataBacking();
    }

    DataItem writeData(MnodeValue update, long version, StreamSource source) {
        long valueHash = update.getValueHash();
        long valueLength = update.getValueLength();
        if (valueHash == 0L && valueLength == 0L && source == null) {
            return new DataItem(0L, 0L, 0L);
        }
        if (source == null) {
            throw new IllegalStateException(L.l("writeData called without a stream or saved value {0}", (Object)update));
        }
        long valueDataId = this.getDataBacking().saveData(source, (int)valueLength);
        return new DataItem(valueHash, valueDataId, valueLength);
    }

    DataItem writeData(MnodeValue update, long version, InputStream is) {
        try {
            long valueHash = update.getValueHash();
            long valueLength = update.getValueLength();
            long valueDataId = this.getDataBacking().saveData(is, (int)valueLength);
            return new DataItem(valueHash, valueDataId, valueLength);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final DataItem writeValue(MnodeEntry mnodeValue, Object value, CacheConfig config) {
        TempOutputStream os = null;
        CacheSerializer serializer = config.getValueSerializer();
        try {
            os = new TempOutputStream();
            long valueHash = this.writeDataStream(os, value, serializer);
            int length = os.getLength();
            StreamSource source = new StreamSource(os);
            long valueDataId = this.getDataBacking().saveData(source, length);
            if (valueDataId <= 0L) {
                throw new IllegalStateException(L.l("Can't save the data '{0}'", valueHash));
            }
            DataItem dataItem = new DataItem(valueHash, valueDataId, length);
            return dataItem;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (os != null) {
                os.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object readData(HashKey key, long valueHash, long valueDataId, CacheSerializer serializer, CacheConfig config) {
        if (valueHash == 0L) {
            return null;
        }
        TempOutputStream os = null;
        try {
            Object object;
            os = new TempOutputStream();
            WriteStream out = Vfs.openWrite(os);
            if (!this.getDataBacking().loadData(valueDataId, out)) {
                log.warning(this + " cannot load data for key=" + key + " from triad");
                out.close();
                Object var10_9 = null;
                return var10_9;
            }
            out.close();
            InputStream is = os.openInputStream();
            try {
                Object value;
                object = value = serializer.deserialize(is);
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                    Object var10_10 = null;
                    return var10_10;
                }
            }
            is.close();
            return object;
        }
        finally {
            if (os != null) {
                os.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object decodeValue(InputStream is, CacheSerializer serializer) {
        if (is == null) {
            return null;
        }
        try {
            Object object = serializer.deserialize(is);
            return object;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            IoUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean readData(HashKey key, MnodeEntry mnodeValue, OutputStream os, CacheConfig config) throws IOException {
        long valueDataId = mnodeValue.getValueDataId();
        if (valueDataId <= 0L) {
            throw new IllegalStateException(L.l("readData may not be called with a null value"));
        }
        WriteStream out = Vfs.openWrite(os);
        try {
            Blob blob = mnodeValue.getBlob();
            if (blob == null && (blob = this.getDataBacking().loadBlob(valueDataId)) != null) {
                mnodeValue.setBlob(blob);
            }
            if (blob != null) {
                this.loadData(blob, out);
                boolean bl = true;
                return bl;
            }
            log.warning(this + " unexpected load failure in readValue key=" + key);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != os) {
                out.close();
            }
        }
    }

    public DataStreamSource createDataSource(long valueDataId) {
        DataStore dataStore = this.getDataBacking().getDataStore();
        if (valueDataId > 0L) {
            return new DataStreamSource(valueDataId, dataStore);
        }
        return null;
    }

    private void loadData(Blob blob, WriteStream out) throws IOException {
        try {
            InputStream is = blob.getBinaryStream();
            if (is instanceof BlobInputStream) {
                BlobInputStream blobIs = (BlobInputStream)is;
                blobIs.readToOutput(out);
            } else {
                out.writeStream(blob.getBinaryStream());
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    void removeData(long valueHash) {
        this.getDataBacking().removeData(valueHash);
    }

    public final long calculateValueHash(Object value, CacheConfig config) {
        try {
            NullOutputStream os = NullOutputStream.NULL;
            return this.writeDataStream(os, value, config.getValueSerializer());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private long writeDataStream(OutputStream os, Object value, CacheSerializer serializer) throws IOException {
        Crc64OutputStream mOut = new Crc64OutputStream(os);
        serializer.serialize(value, mOut);
        mOut.close();
        long hash = mOut.getDigest();
        if (hash == 0L || hash == MnodeEntry.ANY_KEY) {
            return 1L;
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DataItem writeData(StreamSource source) {
        if (source == null) {
            return new DataItem(0L, 0L, 0L);
        }
        InputStream is = null;
        try {
            is = source.getInputStream();
            DataItem dataItem = this.writeData(is);
            return dataItem;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            DataItem dataItem = new DataItem(0L, 0L, 0L);
            return dataItem;
        }
        finally {
            IoUtil.close(is);
        }
    }

    public final DataItem writeData(InputStream is) throws IOException {
        TempOutputStream os = null;
        try {
            Crc64InputStream mIn = new Crc64InputStream(is);
            long valueDataId = this.getDataBacking().saveData(mIn, -1);
            long valueHash = mIn.getDigest();
            if (valueHash == 0L || valueHash == MnodeEntry.ANY_KEY) {
                valueHash = 1L;
            }
            long length = mIn.getLength();
            DataItem dataItem = new DataItem(valueHash, valueDataId, length);
            return dataItem;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (os != null) {
                os.destroy();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._serverId + "]";
    }

    public static class DataItem {
        private long _valueHash;
        private long _dataId;
        private long _length;

        private DataItem(long valueHash, long dataId, long length) {
            this._valueHash = valueHash;
            this._dataId = dataId;
            this._length = length;
        }

        public long getValueDataId() {
            return this._dataId;
        }

        public long getValueHash() {
            return this._valueHash;
        }

        public long getLength() {
            return this._length;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[id=" + this._dataId + ",hash=" + this._valueHash + ",length=" + this._length + "]";
        }
    }
}

